/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Constructor;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes.BaseAccessor;
import org.elasticsearch.common.mvel2.optimizers.impl.refl.nodes.GetterAccessor;

public class ConstructorAccessor
extends BaseAccessor {
    private Constructor constructor;
    private Class[] parmTypes;
    private ExecutableStatement[] parms;
    private int length;
    private boolean coercionNeeded = false;

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        try {
            if (!this.coercionNeeded) {
                try {
                    if (this.nextNode != null) {
                        return this.nextNode.getValue(this.constructor.newInstance(this.executeAll(elCtx, variableFactory)), elCtx, variableFactory);
                    }
                    return this.constructor.newInstance(this.executeAll(elCtx, variableFactory));
                }
                catch (IllegalArgumentException e) {
                    this.coercionNeeded = true;
                    return this.getValue(ctx, elCtx, variableFactory);
                }
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.constructor.newInstance(this.executeAndCoerce(this.parmTypes, elCtx, variableFactory)), elCtx, variableFactory);
            }
            return this.constructor.newInstance(this.executeAndCoerce(this.parmTypes, elCtx, variableFactory));
        }
        catch (Exception e) {
            throw new RuntimeException("cannot construct object", e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        return null;
    }

    private Object[] executeAll(Object ctx, VariableResolverFactory vars) {
        if (this.length == 0) {
            return GetterAccessor.EMPTY;
        }
        Object[] vals = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            vals[i2] = this.parms[i2].getValue(ctx, vars);
        }
        return vals;
    }

    private Object[] executeAndCoerce(Class[] target, Object elCtx, VariableResolverFactory vars) {
        Object[] values2 = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            values2[i2] = DataConversion.convert(this.parms[i2].getValue(elCtx, vars), target[i2]);
        }
        return values2;
    }

    public ConstructorAccessor(Constructor constructor2, ExecutableStatement[] parms) {
        this.constructor = constructor2;
        this.parmTypes = constructor2.getParameterTypes();
        this.length = this.parmTypes.length;
        this.parms = parms;
    }

    public Class getKnownEgressType() {
        return this.constructor.getClass();
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public ExecutableStatement[] getParameters() {
        return this.parms;
    }

    public Class[] getParameterTypes() {
        return this.parmTypes;
    }
}

