/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.integration.impl;

import java.util.HashMap;
import org.elasticsearch.common.mvel2.ast.Function;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.BaseVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.LocalVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionVariableResolverFactory
extends BaseVariableResolverFactory
implements LocalVariableResolverFactory {
    private Function function;
    private boolean noTilt = false;

    public FunctionVariableResolverFactory(Function function, VariableResolverFactory nextFactory, String[] indexedVariables, Object[] parameters2) {
        this.function = function;
        this.variableResolvers = new HashMap();
        this.nextFactory = nextFactory;
        this.indexedVariableNames = indexedVariables;
        this.indexedVariableResolvers = new VariableResolver[indexedVariables.length];
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            this.variableResolvers.put(this.indexedVariableNames[i2], null);
            this.indexedVariableResolvers[i2] = new SimpleValueResolver(parameters2[i2]);
        }
    }

    @Override
    public boolean isResolveable(String name2) {
        return this.variableResolvers.containsKey(name2) || this.nextFactory != null && this.nextFactory.isResolveable(name2);
    }

    @Override
    public VariableResolver createVariable(String name2, Object value2) {
        VariableResolver resolver = this.getVariableResolver(name2);
        if (resolver == null) {
            int idx = this.increaseRegisterTableSize();
            this.indexedVariableNames[idx] = name2;
            this.indexedVariableResolvers[idx] = new SimpleValueResolver(value2);
            this.variableResolvers.put(name2, null);
            return this.indexedVariableResolvers[idx];
        }
        resolver.setValue(value2);
        return resolver;
    }

    @Override
    public VariableResolver createVariable(String name2, Object value2, Class<?> type2) {
        VariableResolver vr;
        VariableResolver variableResolver = vr = this.variableResolvers != null ? (VariableResolver)this.variableResolvers.get(name2) : null;
        if (vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name2);
        }
        return this.createIndexedVariable(this.variableIndexOf(name2), name2, value2);
    }

    @Override
    public VariableResolver createIndexedVariable(int index2, String name2, Object value2) {
        if (this.indexedVariableResolvers[index2 -= this.indexOffset] != null) {
            this.indexedVariableResolvers[index2].setValue(value2);
        } else {
            this.indexedVariableResolvers[index2] = new SimpleValueResolver(value2);
        }
        this.variableResolvers.put(name2, null);
        return this.indexedVariableResolvers[index2];
    }

    @Override
    public VariableResolver createIndexedVariable(int index2, String name2, Object value2, Class<?> type2) {
        if (this.indexedVariableResolvers[index2 -= this.indexOffset] != null) {
            this.indexedVariableResolvers[index2].setValue(value2);
        } else {
            this.indexedVariableResolvers[index2] = new SimpleValueResolver(value2);
        }
        return this.indexedVariableResolvers[index2];
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index2) {
        if (this.indexedVariableResolvers[index2] == null) {
            this.indexedVariableResolvers[index2] = super.getVariableResolver(this.indexedVariableNames[index2]);
            return this.indexedVariableResolvers[index2];
        }
        return this.indexedVariableResolvers[index2];
    }

    @Override
    public VariableResolver getVariableResolver(String name2) {
        int idx = this.variableIndexOf(name2);
        if (idx != -1) {
            if (this.indexedVariableResolvers[idx] == null) {
                this.indexedVariableResolvers[idx] = new SimpleValueResolver(null);
            }
            this.variableResolvers.put(this.indexedVariableNames[idx], null);
            return this.indexedVariableResolvers[idx];
        }
        return super.getVariableResolver(name2);
    }

    @Override
    public boolean isIndexedFactory() {
        return true;
    }

    @Override
    public boolean isTarget(String name2) {
        return this.variableResolvers.containsKey(name2) || this.variableIndexOf(name2) != -1;
    }

    private int increaseRegisterTableSize() {
        String[] oldNames = this.indexedVariableNames;
        VariableResolver[] oldResolvers = this.indexedVariableResolvers;
        int newLength = oldNames.length + 1;
        this.indexedVariableNames = new String[newLength];
        this.indexedVariableResolvers = new VariableResolver[newLength];
        for (int i2 = 0; i2 < oldNames.length; ++i2) {
            this.indexedVariableNames[i2] = oldNames[i2];
            this.indexedVariableResolvers[i2] = oldResolvers[i2];
        }
        return newLength - 1;
    }

    public void updateParameters(Object[] parameters2) {
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            this.indexedVariableResolvers[i2] = new SimpleValueResolver(parameters2[i2]);
        }
    }

    public VariableResolver[] getIndexedVariableResolvers() {
        return this.indexedVariableResolvers;
    }

    public void setIndexedVariableResolvers(VariableResolver[] vr) {
        this.indexedVariableResolvers = vr;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setIndexOffset(int offset2) {
        this.indexOffset = offset2;
    }

    public VariableResolverFactory setNoTilt(boolean noTilt) {
        this.noTilt = noTilt;
        return this;
    }

    @Override
    public void setTiltFlag(boolean tiltFlag) {
        if (!this.noTilt) {
            super.setTiltFlag(tiltFlag);
        }
    }
}

