/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.integration.impl;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.mvel2.UnresolveablePropertyException;
import org.elasticsearch.common.mvel2.integration.VariableResolver;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.LocalVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolver;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalVariableResolverFactory
extends MapVariableResolverFactory
implements LocalVariableResolverFactory {
    private boolean noTilt = false;

    public DefaultLocalVariableResolverFactory() {
        super(new HashMap());
    }

    public DefaultLocalVariableResolverFactory(Map<String, Object> variables) {
        super(variables);
    }

    public DefaultLocalVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        super(variables, nextFactory);
    }

    public DefaultLocalVariableResolverFactory(Map<String, Object> variables, boolean cachingSafe) {
        super(variables);
    }

    public DefaultLocalVariableResolverFactory(VariableResolverFactory nextFactory) {
        super(new HashMap<String, Object>(), nextFactory);
    }

    public DefaultLocalVariableResolverFactory(VariableResolverFactory nextFactory, String[] indexedVariables) {
        super(new HashMap<String, Object>(), nextFactory);
        this.indexedVariableNames = indexedVariables;
        this.indexedVariableResolvers = new VariableResolver[indexedVariables.length];
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index2) {
        if (this.indexedVariableNames == null) {
            return null;
        }
        if (this.indexedVariableResolvers[index2] == null) {
            this.indexedVariableResolvers[index2] = super.getVariableResolver(this.indexedVariableNames[index2]);
            return this.indexedVariableResolvers[index2];
        }
        return this.indexedVariableResolvers[index2];
    }

    @Override
    public VariableResolver getVariableResolver(String name2) {
        if (this.indexedVariableNames == null) {
            return super.getVariableResolver(name2);
        }
        int idx = this.variableIndexOf(name2);
        if (idx != -1) {
            if (this.indexedVariableResolvers[idx] == null) {
                this.indexedVariableResolvers[idx] = new SimpleValueResolver(null);
            }
            this.variableResolvers.put(this.indexedVariableNames[idx], null);
            return this.indexedVariableResolvers[idx];
        }
        return super.getVariableResolver(name2);
    }

    @Override
    public VariableResolver createVariable(String name2, Object value2, Class<?> type2) {
        VariableResolver vr;
        if (this.indexedVariableNames == null) {
            return super.createVariable(name2, value2, type2);
        }
        boolean newVar = false;
        try {
            int idx = this.variableIndexOf(name2);
            if (idx != -1) {
                vr = new SimpleValueResolver(value2);
                if (this.indexedVariableResolvers[idx] == null) {
                    this.indexedVariableResolvers[idx] = vr;
                }
            } else {
                return super.createVariable(name2, value2, type2);
            }
            this.variableResolvers.put(this.indexedVariableNames[idx], vr);
            vr = this.indexedVariableResolvers[idx];
            newVar = true;
        }
        catch (UnresolveablePropertyException e) {
            vr = null;
        }
        if (!newVar && vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name2);
        }
        vr = new MapVariableResolver(this.variables, name2, type2);
        this.addResolver(name2, vr).setValue(value2);
        return vr;
    }

    public VariableResolverFactory setNoTilt(boolean noTilt) {
        this.noTilt = noTilt;
        return this;
    }

    @Override
    public void setTiltFlag(boolean tiltFlag) {
        if (!this.noTilt) {
            super.setTiltFlag(tiltFlag);
        }
    }
}

