/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.conversion;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.mvel2.ConversionException;
import org.elasticsearch.common.mvel2.ConversionHandler;
import org.elasticsearch.common.mvel2.conversion.Converter;

public class IntArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String[].class, new Converter(){

            public Object convert(Object o) {
                String[] old = (String[])o;
                Integer[] n = new Integer[old.length];
                for (int i2 = 0; i2 < old.length; ++i2) {
                    n[i2] = Integer.parseInt(old[i2]);
                }
                return n;
            }
        });
        CNV.put(Object[].class, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                Integer[] n = new Integer[old.length];
                for (int i2 = 0; i2 < old.length; ++i2) {
                    n[i2] = Integer.parseInt(String.valueOf(old[i2]));
                }
                return n;
            }
        });
    }
}

