/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.HashMap;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.BlockNode;
import org.elasticsearch.common.mvel2.ast.NestedStatement;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.mvel2.util.CompilerTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class IfNode
extends BlockNode
implements NestedStatement {
    protected ExecutableStatement condition;
    protected ExecutableStatement nestedStatement;
    protected IfNode elseIf;
    protected ExecutableStatement elseBlock;
    protected boolean idxAlloc = false;

    public IfNode(char[] expr, int start2, int offset2, int blockStart, int blockOffset, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        if (expr == null || offset2 == 0) {
            throw new CompileException("statement expected", expr, start2);
        }
        this.start = start2;
        this.offset = offset2;
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        boolean bl = this.idxAlloc = pCtx != null && pCtx.isIndexAllocation();
        if ((fields2 & 0x10) != 0) {
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(expr, start2, offset2, pCtx);
            CompilerTools.expectType(this.condition, Boolean.class, true);
            if (pCtx != null) {
                pCtx.pushVariableScope();
            }
            this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(expr, blockStart, blockOffset, pCtx);
            if (pCtx != null) {
                pCtx.popVariableScope();
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            return this.nestedStatement.getValue(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValueAccelerated(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)MVEL.eval(this.expr, this.start, this.offset, ctx, factory)).booleanValue()) {
            return MVEL.eval(this.expr, this.blockStart, this.blockOffset, ctx, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public IfNode setElseIf(IfNode elseIf) {
        this.elseIf = elseIf;
        return this.elseIf;
    }

    public ExecutableStatement getElseBlock() {
        return this.elseBlock;
    }

    public IfNode setElseBlock(char[] block, int cursor, int offset2, ParserContext ctx) {
        this.elseBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, cursor, offset2, ctx);
        return this;
    }

    public String toString() {
        return new String(this.expr, this.start, this.offset);
    }
}

