/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.HashMap;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.BlockNode;
import org.elasticsearch.common.mvel2.ast.RedundantCodeException;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.mvel2.util.CompilerTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class ForNode
extends BlockNode {
    protected String item;
    protected ExecutableStatement initializer;
    protected ExecutableStatement condition;
    protected ExecutableStatement after;
    protected boolean indexAlloc = false;

    public ForNode(char[] expr, int start2, int offset2, int blockStart, int blockEnd, int fields2, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        this.blockStart = blockStart;
        this.blockOffset = blockEnd;
        boolean varsEscape = this.buildForEach(expr, this.start, this.offset, this.blockStart, this.blockOffset, fields2, pCtx);
        boolean bl = this.indexAlloc = pCtx != null && pCtx.isIndexAllocation();
        if ((fields2 & 0x10) != 0 && this.compiledBlock.isEmptyStatement() && !varsEscape) {
            throw new RedundantCodeException();
        }
        if (pCtx != null) {
            pCtx.popVariableScope();
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        VariableResolverFactory ctxFactory = this.indexAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(1), factory);
        this.initializer.getValue(ctx, thisValue, ctxFactory);
        while (((Boolean)this.condition.getValue(ctx, thisValue, ctxFactory)).booleanValue()) {
            Object v = this.compiledBlock.getValue(ctx, thisValue, ctxFactory);
            if (ctxFactory.tiltFlag()) {
                return v;
            }
            this.after.getValue(ctx, thisValue, ctxFactory);
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory = new MapVariableResolverFactory(new HashMap<String, Object>(1), factory);
        this.initializer.getValue(ctx, thisValue, factory);
        while (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            Object v = this.compiledBlock.getValue(ctx, thisValue, factory);
            if (factory.tiltFlag()) {
                return v;
            }
            this.after.getValue(ctx, thisValue, factory);
        }
        return null;
    }

    private boolean buildForEach(char[] condition, int start2, int offset2, int blockStart, int blockEnd, int fields2, ParserContext pCtx) {
        int end2 = start2 + offset2;
        int cursor = ForNode.nextCondPart(condition, start2, end2, false);
        boolean varsEscape = false;
        try {
            ParserContext spCtx = pCtx;
            spCtx = pCtx != null ? pCtx.createSubcontext().createColoringSubcontext() : new ParserContext();
            this.initializer = (ExecutableStatement)ParseTools.subCompileExpression(condition, start2, cursor - start2 - 1, spCtx);
            if (pCtx != null) {
                pCtx.pushVariableScope();
            }
            try {
                start2 = cursor;
                cursor = ForNode.nextCondPart(condition, start2, end2, false);
                this.condition = (ExecutableStatement)ParseTools.subCompileExpression(condition, start2, cursor - start2 - 1, spCtx);
                CompilerTools.expectType(this.condition, Boolean.class, (fields2 & 0x10) != 0);
            }
            catch (CompileException e) {
                if (e.getExpr().length == 0) {
                    e.setExpr(this.expr);
                    while (start2 < this.expr.length && ParseTools.isWhitespace(this.expr[start2])) {
                        ++start2;
                    }
                    e.setCursor(start2);
                }
                throw e;
            }
            start2 = cursor;
            this.after = (ExecutableStatement)ParseTools.subCompileExpression(condition, start2, ForNode.nextCondPart(condition, start2, end2, true) - start2, spCtx);
            if (spCtx != null && (fields2 & 0x10) != 0 && spCtx.isVariablesEscape()) {
                if (pCtx != spCtx) {
                    pCtx.addVariables(spCtx.getVariables());
                }
                varsEscape = true;
            } else if (spCtx != null && pCtx != null) {
                pCtx.addVariables(spCtx.getVariables());
            }
            this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, blockStart, blockEnd, spCtx);
        }
        catch (NegativeArraySizeException e) {
            throw new CompileException("wrong syntax; did you mean to use 'foreach'?", this.expr, start2);
        }
        return varsEscape;
    }

    private static int nextCondPart(char[] condition, int cursor, int end2, boolean allowEnd) {
        while (cursor < end2) {
            if (condition[cursor] == ';') {
                return ++cursor;
            }
            ++cursor;
        }
        if (!allowEnd) {
            throw new CompileException("expected ;", condition, cursor);
        }
        return cursor;
    }
}

