/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.ItemResolverFactory;
import org.elasticsearch.common.mvel2.util.CompilerTools;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class Fold
extends ASTNode {
    private ExecutableStatement subEx;
    private ExecutableStatement dataEx;
    private ExecutableStatement constraintEx;

    public Fold(char[] expr, int start2, int offset2, int fields2, ParserContext pCtx) {
        super(pCtx);
        int cursor;
        this.expr = expr;
        this.start = start2;
        this.offset = offset2;
        int end2 = start2 + offset2;
        for (cursor = start2; cursor < end2; ++cursor) {
            if (!ParseTools.isWhitespace(expr[cursor])) continue;
            while (cursor < end2 && ParseTools.isWhitespace(expr[cursor])) {
                ++cursor;
            }
            if (expr[cursor] == 'i' && expr[cursor + 1] == 'n' && ParseTools.isJunct(expr[cursor + 2])) break;
        }
        this.subEx = (ExecutableStatement)ParseTools.subCompileExpression(expr, start2, cursor - start2 - 1, pCtx);
        int st = cursor += 2;
        while (cursor < end2) {
            if (ParseTools.isWhitespace(expr[cursor])) {
                while (cursor < end2 && ParseTools.isWhitespace(expr[cursor])) {
                    ++cursor;
                }
                if (expr[cursor] == 'i' && expr[cursor + 1] == 'f' && ParseTools.isJunct(expr[cursor + 2])) {
                    int s2 = cursor + 2;
                    this.constraintEx = (ExecutableStatement)ParseTools.subCompileExpression(expr, s2, end2 - s2, pCtx);
                    break;
                }
            }
            ++cursor;
        }
        this.dataEx = (ExecutableStatement)ParseTools.subCompileExpression(expr, st, cursor - st, pCtx);
        CompilerTools.expectType(this.dataEx, Collection.class, (fields2 & 0x10) != 0);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ArrayList<Object> list2;
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver("$");
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        if (this.constraintEx != null) {
            Collection col = (Collection)this.dataEx.getValue(ctx, thisValue, factory);
            list2 = new ArrayList<Object>(col.size());
            for (Object o : col) {
                itemR.value = o;
                if (!((Boolean)this.constraintEx.getValue(ctx, thisValue, itemFactory)).booleanValue()) continue;
                list2.add(this.subEx.getValue(o, thisValue, itemFactory));
            }
        } else {
            Collection col = (Collection)this.dataEx.getValue(ctx, thisValue, factory);
            list2 = new ArrayList(col.size());
            for (Object o : col) {
                itemR.value = o;
                list2.add(this.subEx.getValue(itemR.value, thisValue, itemFactory));
            }
        }
        return list2;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ArrayList<Object> list2;
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver("$");
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        if (this.constraintEx != null) {
            Object x = this.dataEx.getValue(ctx, thisValue, factory);
            if (!(x instanceof Collection)) {
                throw new CompileException("was expecting type: Collection; but found type: " + (x == null ? "null" : x.getClass().getName()), this.expr, this.start);
            }
            list2 = new ArrayList<Object>(((Collection)x).size());
            for (Object o : (Collection)x) {
                itemR.value = o;
                if (!((Boolean)this.constraintEx.getValue(ctx, thisValue, itemFactory)).booleanValue()) continue;
                list2.add(this.subEx.getValue(o, thisValue, itemFactory));
            }
        } else {
            Object x = this.dataEx.getValue(ctx, thisValue, factory);
            if (!(x instanceof Collection)) {
                throw new CompileException("was expecting type: Collection; but found type: " + (x == null ? "null" : x.getClass().getName()), this.expr, this.start);
            }
            list2 = new ArrayList(((Collection)x).size());
            for (Object o : (Collection)x) {
                itemR.value = o;
                list2.add(this.subEx.getValue(itemR.value, thisValue, itemFactory));
            }
        }
        return list2;
    }

    public Class getEgressType() {
        return Collection.class;
    }
}

