/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.asm;

import org.elasticsearch.common.mvel2.asm.ByteVector;
import org.elasticsearch.common.mvel2.asm.ClassReader;
import org.elasticsearch.common.mvel2.asm.ClassWriter;
import org.elasticsearch.common.mvel2.asm.Label;

public class Attribute {
    public final String type;
    byte[] value;
    Attribute next;

    protected Attribute(String type2) {
        this.type = type2;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return null;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        Attribute attr2 = new Attribute(this.type);
        attr2.value = new byte[len];
        System.arraycopy(cr.b, off, attr2.value, 0, len);
        return attr2;
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector v = new ByteVector();
        v.data = this.value;
        v.length = this.value.length;
        return v;
    }

    final int getCount() {
        int count2 = 0;
        Attribute attr2 = this;
        while (attr2 != null) {
            ++count2;
            attr2 = attr2.next;
        }
        return count2;
    }

    final int getSize(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        Attribute attr2 = this;
        int size2 = 0;
        while (attr2 != null) {
            cw.newUTF8(attr2.type);
            size2 += attr2.write((ClassWriter)cw, (byte[])code, (int)len, (int)maxStack, (int)maxLocals).length + 6;
            attr2 = attr2.next;
        }
        return size2;
    }

    final void put(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals, ByteVector out) {
        Attribute attr2 = this;
        while (attr2 != null) {
            ByteVector b = attr2.write(cw, code, len, maxStack, maxLocals);
            out.putShort(cw.newUTF8(attr2.type)).putInt(b.length);
            out.putByteArray(b.data, 0, b.length);
            attr2 = attr2.next;
        }
    }
}

