/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.DataConversion;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.OptimizationFailure;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.PropertyAccessException;
import org.elasticsearch.common.mvel2.ast.Function;
import org.elasticsearch.common.mvel2.ast.Proto;
import org.elasticsearch.common.mvel2.ast.TypeDescriptor;
import org.elasticsearch.common.mvel2.compiler.AbstractParser;
import org.elasticsearch.common.mvel2.integration.GlobalListenerFactory;
import org.elasticsearch.common.mvel2.integration.PropertyHandlerFactory;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.ImmutableDefaultFactory;
import org.elasticsearch.common.mvel2.util.ErrorUtil;
import org.elasticsearch.common.mvel2.util.MethodStub;
import org.elasticsearch.common.mvel2.util.ParseTools;
import org.elasticsearch.common.mvel2.util.PropertyTools;
import org.elasticsearch.common.mvel2.util.ReflectionUtil;
import org.elasticsearch.common.mvel2.util.StringAppender;
import org.elasticsearch.common.mvel2.util.Varargs;

public class PropertyAccessor {
    private int start = 0;
    private int cursor = 0;
    private int st;
    private char[] property;
    private int length;
    private int end;
    private Object thisReference;
    private Object ctx;
    private Object curr;
    private Class currType = null;
    private boolean first = true;
    private boolean nullHandle = false;
    private VariableResolverFactory variableFactory;
    private ParserContext pCtx;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private static final int WITH = 3;
    private static final Object[] EMPTYARG = new Object[0];
    private static final WeakHashMap<Class, WeakHashMap<Integer, WeakReference<Member>>> READ_PROPERTY_RESOLVER_CACHE = new WeakHashMap(10);
    private static final WeakHashMap<Class, WeakHashMap<Integer, WeakReference<Member>>> WRITE_PROPERTY_RESOLVER_CACHE = new WeakHashMap(10);
    private static final WeakHashMap<Class, WeakHashMap<Integer, WeakReference<Object[]>>> METHOD_RESOLVER_CACHE = new WeakHashMap(10);
    private static final WeakHashMap<Member, WeakReference<Class[]>> METHOD_PARMTYPES_CACHE = new WeakHashMap(10);

    public PropertyAccessor(String property, Object ctx) {
        this.property = property.toCharArray();
        this.length = this.end = this.property.length;
        this.ctx = ctx;
        this.variableFactory = new ImmutableDefaultFactory();
    }

    public PropertyAccessor(char[] property, Object ctx, VariableResolverFactory resolver, Object thisReference, ParserContext pCtx) {
        this.property = property;
        this.length = this.end = property.length;
        this.ctx = ctx;
        this.variableFactory = resolver;
        this.thisReference = thisReference;
        this.pCtx = pCtx;
    }

    public PropertyAccessor(char[] property, int start2, int offset2, Object ctx, VariableResolverFactory resolver, Object thisReference, ParserContext pCtx) {
        this.property = property;
        this.st = this.start = start2;
        this.cursor = this.start;
        this.length = offset2;
        this.end = start2 + offset2;
        this.ctx = ctx;
        this.variableFactory = resolver;
        this.thisReference = thisReference;
        this.pCtx = pCtx;
    }

    public static Object get(String property, Object ctx) {
        return new PropertyAccessor(property, ctx).get();
    }

    public static Object get(char[] property, int offset2, int end2, Object ctx, VariableResolverFactory resolver, Object thisReferece, ParserContext pCtx) {
        return new PropertyAccessor(property, offset2, end2, ctx, resolver, thisReferece, pCtx).get();
    }

    public static Object get(String property, Object ctx, VariableResolverFactory resolver, Object thisReference, ParserContext pCtx) {
        return new PropertyAccessor(property.toCharArray(), ctx, resolver, thisReference, pCtx).get();
    }

    public static void set(Object ctx, String property, Object value2) {
        new PropertyAccessor(property, ctx).set(value2);
    }

    public static void set(Object ctx, VariableResolverFactory resolver, String property, Object value2, ParserContext pCtx) {
        new PropertyAccessor(property.toCharArray(), ctx, resolver, null, pCtx).set(value2);
    }

    private Object get() {
        this.curr = this.ctx;
        try {
            if (!MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING) {
                return this.getNormal();
            }
            return this.getAllowOverride();
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", this.property, this.cursor, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", this.property, this.cursor, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException("array or collections index out of bounds in property: " + new String(this.property, this.cursor, this.length), this.property, this.cursor, e);
        }
        catch (CompileException e) {
            throw ErrorUtil.rewriteIfNeeded(e, this.property, this.st);
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException("null pointer exception in property: " + new String(this.property), this.property, this.cursor, e);
        }
        catch (Exception e) {
            throw new PropertyAccessException("unknown exception in expression: " + new String(this.property), this.property, this.cursor, e);
        }
    }

    private Object getNormal() throws Exception {
        while (this.cursor < this.end) {
            switch (this.nextToken()) {
                case 0: {
                    this.curr = this.getBeanProperty(this.curr, this.capture());
                    break;
                }
                case 1: {
                    this.curr = this.getMethod(this.curr, this.capture());
                    break;
                }
                case 2: {
                    this.curr = this.getCollectionProperty(this.curr, this.capture());
                    break;
                }
                case 3: {
                    this.curr = this.getWithProperty(this.curr);
                }
            }
            if (this.nullHandle) {
                if (this.curr == null) {
                    return null;
                }
                this.nullHandle = false;
            }
            this.first = false;
        }
        return this.curr;
    }

    private Object getAllowOverride() throws Exception {
        while (this.cursor < this.end) {
            switch (this.nextToken()) {
                case 0: {
                    this.curr = this.getBeanPropertyAO(this.curr, this.capture());
                    if (this.curr != null || !PropertyHandlerFactory.hasNullPropertyHandler()) break;
                    this.curr = PropertyHandlerFactory.getNullPropertyHandler().getProperty(this.capture(), this.ctx, this.variableFactory);
                    break;
                }
                case 1: {
                    this.curr = this.getMethod(this.curr, this.capture());
                    if (this.curr != null || !PropertyHandlerFactory.hasNullMethodHandler()) break;
                    this.curr = PropertyHandlerFactory.getNullMethodHandler().getProperty(this.capture(), this.ctx, this.variableFactory);
                    break;
                }
                case 2: {
                    this.curr = this.getCollectionPropertyAO(this.curr, this.capture());
                    break;
                }
                case 3: {
                    this.curr = this.getWithProperty(this.curr);
                }
            }
            if (this.nullHandle) {
                if (this.curr == null) {
                    return null;
                }
                this.nullHandle = false;
            } else if (this.curr == null && this.cursor < this.end) {
                throw new NullPointerException();
            }
            this.first = false;
        }
        return this.curr;
    }

    private void set(Object value2) {
        block40: {
            this.curr = this.ctx;
            try {
                int oLength = this.end;
                this.end = ParseTools.findAbsoluteLast(this.property);
                this.curr = this.get();
                if (this.curr == null) {
                    throw new PropertyAccessException("cannot bind to null context: " + new String(this.property, this.cursor, this.length), this.property, this.cursor);
                }
                this.end = oLength;
                if (this.nextToken() == 2) {
                    int _start = ++this.cursor;
                    this.whiteSpaceSkip();
                    if (this.cursor == this.length || this.scanTo(']')) {
                        throw new PropertyAccessException("unterminated '['", this.property, this.cursor);
                    }
                    String ex = new String(this.property, _start, this.cursor - _start);
                    if (!MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING) {
                        if (this.curr instanceof Map) {
                            ((Map)this.curr).put(MVEL.eval(ex, this.ctx, this.variableFactory), value2);
                        } else if (this.curr instanceof List) {
                            ((List)this.curr).set(MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), value2);
                        } else if (PropertyHandlerFactory.hasPropertyHandler(this.curr.getClass())) {
                            PropertyHandlerFactory.getPropertyHandler(this.curr.getClass()).setProperty(ex, this.ctx, this.variableFactory, value2);
                        } else if (this.curr.getClass().isArray()) {
                            Array.set(this.curr, MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), DataConversion.convert(value2, ParseTools.getBaseComponentType(this.curr.getClass())));
                        } else {
                            throw new PropertyAccessException("cannot bind to collection property: " + new String(this.property) + ": not a recognized collection type: " + this.ctx.getClass(), this.property, this.cursor);
                        }
                        return;
                    }
                    GlobalListenerFactory.notifySetListeners(this.ctx, ex, this.variableFactory, value2);
                    if (this.curr instanceof Map) {
                        if (PropertyHandlerFactory.hasPropertyHandler(Map.class)) {
                            PropertyHandlerFactory.getPropertyHandler(Map.class).setProperty(ex, this.curr, this.variableFactory, value2);
                        } else {
                            ((Map)this.curr).put(MVEL.eval(ex, this.ctx, this.variableFactory), value2);
                        }
                    } else if (this.curr instanceof List) {
                        if (PropertyHandlerFactory.hasPropertyHandler(List.class)) {
                            PropertyHandlerFactory.getPropertyHandler(List.class).setProperty(ex, this.curr, this.variableFactory, value2);
                        } else {
                            ((List)this.curr).set(MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), value2);
                        }
                    } else if (this.curr.getClass().isArray()) {
                        if (PropertyHandlerFactory.hasPropertyHandler(Array.class)) {
                            PropertyHandlerFactory.getPropertyHandler(Array.class).setProperty(ex, this.curr, this.variableFactory, value2);
                        } else {
                            Array.set(this.curr, MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), DataConversion.convert(value2, ParseTools.getBaseComponentType(this.curr.getClass())));
                        }
                    } else if (PropertyHandlerFactory.hasPropertyHandler(this.curr.getClass())) {
                        PropertyHandlerFactory.getPropertyHandler(this.curr.getClass()).setProperty(ex, this.curr, this.variableFactory, value2);
                    } else {
                        throw new PropertyAccessException("cannot bind to collection property: " + new String(this.property) + ": not a recognized collection type: " + this.ctx.getClass(), this.property, this.cursor);
                    }
                    return;
                }
                if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(this.curr.getClass())) {
                    PropertyHandlerFactory.getPropertyHandler(this.curr.getClass()).setProperty(this.capture(), this.curr, this.variableFactory, value2);
                    return;
                }
                String tk = this.capture();
                Member member = PropertyAccessor.checkWriteCache(this.curr.getClass(), tk == null ? 0 : tk.hashCode());
                if (member == null) {
                    member = value2 != null ? PropertyTools.getFieldOrWriteAccessor(this.curr.getClass(), tk, value2.getClass()) : PropertyTools.getFieldOrWriteAccessor(this.curr.getClass(), tk);
                    PropertyAccessor.addWriteCache(this.curr.getClass(), tk != null ? tk.hashCode() : -1, member);
                }
                if (member instanceof Method) {
                    Method meth = (Method)member;
                    Class[] paramaterTypes = PropertyAccessor.checkParmTypesCache(meth);
                    if (value2 != null && !paramaterTypes[0].isAssignableFrom(value2.getClass())) {
                        if (!DataConversion.canConvert(paramaterTypes[0], value2.getClass())) {
                            throw new CompileException("cannot convert type: " + value2.getClass() + ": to " + meth.getParameterTypes()[0], this.property, this.cursor);
                        }
                        meth.invoke(this.curr, DataConversion.convert(value2, paramaterTypes[0]));
                    } else {
                        meth.invoke(this.curr, value2);
                    }
                    break block40;
                }
                if (member != null) {
                    Field fld = (Field)member;
                    if (value2 != null && !fld.getType().isAssignableFrom(value2.getClass())) {
                        if (!DataConversion.canConvert(fld.getType(), value2.getClass())) {
                            throw new CompileException("cannot convert type: " + value2.getClass() + ": to " + fld.getType(), this.property, this.cursor);
                        }
                        fld.set(this.curr, DataConversion.convert(value2, fld.getType()));
                    } else {
                        fld.set(this.curr, value2);
                    }
                    break block40;
                }
                if (this.curr instanceof Map) {
                    ((Map)this.curr).put(MVEL.eval(tk, this.ctx, this.variableFactory), value2);
                    break block40;
                }
                throw new PropertyAccessException("could not access/write property (" + tk + ") in: " + (this.curr == null ? "Unknown" : this.curr.getClass().getName()), this.property, this.cursor);
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException("could not access property", this.property, this.st, e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException("could not access property", this.property, this.st, e);
            }
        }
    }

    private int nextToken() {
        this.st = this.cursor;
        switch (this.property[this.st]) {
            case '[': {
                return 2;
            }
            case '{': {
                if (this.property[this.cursor - 1] != '.') break;
                return 3;
            }
            case '.': {
                while (this.cursor < this.end && ParseTools.isWhitespace(this.property[this.cursor])) {
                    ++this.cursor;
                }
                if (this.st + 1 != this.end) {
                    this.cursor = ++this.st;
                    switch (this.property[this.st]) {
                        case '?': {
                            this.cursor = ++this.st;
                            this.nullHandle = true;
                            break;
                        }
                        case '{': {
                            return 3;
                        }
                    }
                }
            }
            case '?': {
                if (this.cursor != this.start) break;
                this.cursor = ++this.st;
                this.nullHandle = true;
            }
        }
        while (true) {
            if (this.cursor < this.end && ParseTools.isWhitespace(this.property[this.cursor])) {
                ++this.cursor;
                continue;
            }
            if (this.cursor >= this.end || this.property[this.cursor] != '.') break;
            ++this.cursor;
        }
        this.st = this.cursor;
        while (++this.cursor < this.end && Character.isJavaIdentifierPart(this.property[this.cursor])) {
        }
        if (this.cursor < this.end) {
            while (ParseTools.isWhitespace(this.property[this.cursor])) {
                ++this.cursor;
            }
            switch (this.property[this.cursor]) {
                case '[': {
                    return 2;
                }
                case '(': {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    private String capture() {
        return new String(this.property, this.st, this.trimLeft(this.cursor) - this.st);
    }

    protected int trimLeft(int pos2) {
        while (pos2 > 0 && ParseTools.isWhitespace(this.property[pos2 - 1])) {
            --pos2;
        }
        return pos2;
    }

    public static void clearPropertyResolverCache() {
        READ_PROPERTY_RESOLVER_CACHE.clear();
        WRITE_PROPERTY_RESOLVER_CACHE.clear();
        METHOD_RESOLVER_CACHE.clear();
    }

    public static void reportCacheSizes() {
        System.out.println("read property cache: " + READ_PROPERTY_RESOLVER_CACHE.size());
        for (Class cls : READ_PROPERTY_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + READ_PROPERTY_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
        System.out.println("write property cache: " + WRITE_PROPERTY_RESOLVER_CACHE.size());
        for (Class cls : WRITE_PROPERTY_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + WRITE_PROPERTY_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
        System.out.println("method cache: " + METHOD_RESOLVER_CACHE.size());
        for (Class cls : METHOD_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + METHOD_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReadCache(Class cls, Integer property, Member member) {
        WeakHashMap<Class, WeakHashMap<Integer, WeakReference<Member>>> weakHashMap = READ_PROPERTY_RESOLVER_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Integer, WeakReference<Member>> nestedMap = READ_PROPERTY_RESOLVER_CACHE.get(cls);
            if (nestedMap == null) {
                nestedMap = new WeakHashMap();
                READ_PROPERTY_RESOLVER_CACHE.put(cls, nestedMap);
            }
            nestedMap.put(property, new WeakReference<Member>(member));
        }
    }

    private static Member checkReadCache(Class cls, Integer property) {
        WeakReference<Member> member;
        WeakHashMap<Integer, WeakReference<Member>> map = READ_PROPERTY_RESOLVER_CACHE.get(cls);
        if (map != null && (member = map.get(property)) != null) {
            return (Member)member.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addWriteCache(Class cls, Integer property, Member member) {
        WeakHashMap<Class, WeakHashMap<Integer, WeakReference<Member>>> weakHashMap = WRITE_PROPERTY_RESOLVER_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Integer, WeakReference<Member>> map = WRITE_PROPERTY_RESOLVER_CACHE.get(cls);
            if (map == null) {
                map = new WeakHashMap();
                WRITE_PROPERTY_RESOLVER_CACHE.put(cls, map);
            }
            map.put(property, new WeakReference<Member>(member));
        }
    }

    private static Member checkWriteCache(Class cls, Integer property) {
        WeakReference member;
        Map map = WRITE_PROPERTY_RESOLVER_CACHE.get(cls);
        if (map != null && (member = (WeakReference)map.get(property)) != null) {
            return (Member)member.get();
        }
        return null;
    }

    public static Class[] checkParmTypesCache(Method member) {
        Class[] ret;
        WeakReference<Class[]> pt = METHOD_PARMTYPES_CACHE.get(member);
        if (pt == null || (ret = (Class[])pt.get()) == null) {
            ret = member.getParameterTypes();
            pt = new WeakReference<Class<?>[]>(ret);
            METHOD_PARMTYPES_CACHE.put(member, pt);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMethodCache(Class cls, Integer property, Method member) {
        WeakHashMap<Class, WeakHashMap<Integer, WeakReference<Object[]>>> weakHashMap = METHOD_RESOLVER_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Integer, WeakReference<Object>> map = METHOD_RESOLVER_CACHE.get(cls);
            if (map == null) {
                map = new WeakHashMap();
                METHOD_RESOLVER_CACHE.put(cls, map);
            }
            map.put(property, new WeakReference<Object[]>(new Object[]{member, member.getParameterTypes()}));
        }
    }

    private static Object[] checkMethodCache(Class cls, Integer property) {
        WeakReference ref;
        Map map = METHOD_RESOLVER_CACHE.get(cls);
        if (map != null && (ref = (WeakReference)map.get(property)) != null) {
            return (Object[])ref.get();
        }
        return null;
    }

    private Object getBeanPropertyAO(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        if (ctx != null && PropertyHandlerFactory.hasPropertyHandler(ctx.getClass())) {
            return PropertyHandlerFactory.getPropertyHandler(ctx.getClass()).getProperty(property, ctx, this.variableFactory);
        }
        GlobalListenerFactory.notifyGetListeners(ctx, property, this.variableFactory);
        return this.getBeanProperty(ctx, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Object tryStatic;
        if (this.first) {
            if ("this".equals(property)) {
                return this.ctx;
            }
            if (AbstractParser.LITERALS.containsKey(property)) {
                return AbstractParser.LITERALS.get(property);
            }
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                return this.variableFactory.getVariableResolver(property).getValue();
            }
        }
        if (ctx != null) {
            Class cls;
            if (ctx instanceof Class) {
                if (MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS && "class".equals(property)) {
                    return ctx;
                }
                cls = (Class)ctx;
            } else {
                cls = ctx.getClass();
            }
            Member member = PropertyAccessor.checkReadCache(cls, property.hashCode());
            if (member == null) {
                member = PropertyTools.getFieldOrAccessor(cls, property);
                PropertyAccessor.addReadCache(cls, property.hashCode(), member);
            }
            if (member instanceof Method) {
                try {
                    return ((Method)member).invoke(ctx, EMPTYARG);
                }
                catch (IllegalAccessException e) {
                    Member member2 = member;
                    synchronized (member2) {
                        Object object;
                        try {
                            ((Method)member).setAccessible(true);
                            object = ((Method)member).invoke(ctx, EMPTYARG);
                            ((Method)member).setAccessible(false);
                        }
                        catch (Throwable throwable) {
                            ((Method)member).setAccessible(false);
                            throw throwable;
                        }
                        return object;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (member.getDeclaringClass().equals(ctx)) {
                        try {
                            Class<?> c = Class.forName(member.getDeclaringClass().getName() + "$" + property);
                            throw new CompileException("name collision between innerclass: " + c.getCanonicalName() + "; and bean accessor: " + property + " (" + member.toString() + ")", this.property, this.st);
                        }
                        catch (ClassNotFoundException e2) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
            if (member != null) {
                this.currType = ReflectionUtil.toNonPrimitiveType(((Field)member).getType());
                return ((Field)member).get(ctx);
            }
            if (ctx instanceof Map && (((Map)ctx).containsKey(property) || this.nullHandle)) {
                if (ctx instanceof Proto.ProtoInstance) {
                    return ((Proto.ProtoInstance)ctx).get(property).call(null, this.thisReference, this.variableFactory, ParseTools.EMPTY_OBJ_ARR);
                }
                return ((Map)ctx).get(property);
            }
            if ("length".equals(property) && ctx.getClass().isArray()) {
                return Array.getLength(ctx);
            }
            if (ctx instanceof Class) {
                Class c = (Class)ctx;
                for (Method m : c.getMethods()) {
                    if (!property.equals(m.getName())) continue;
                    if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
                        return m.invoke(ctx, ParseTools.EMPTY_OBJ_ARR);
                    }
                    return m;
                }
                try {
                    return ParseTools.findClass(this.variableFactory, c.getName() + "$" + property, this.pCtx);
                }
                catch (ClassNotFoundException cnfe) {
                }
            } else if (PropertyHandlerFactory.hasPropertyHandler(cls)) {
                return PropertyHandlerFactory.getPropertyHandler(cls).getProperty(property, ctx, this.variableFactory);
            }
        }
        if ((tryStatic = this.tryStaticAccess()) != null) {
            if (tryStatic instanceof Class || tryStatic instanceof Method) {
                return tryStatic;
            }
            return ((Field)tryStatic).get(null);
        }
        if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
            return this.getMethod(ctx, property);
        }
        if (ctx == null) {
            throw new PropertyAccessException("unresolvable property or identifier: " + property, this.property, this.st);
        }
        throw new PropertyAccessException("could not access: " + property + "; in class: " + ctx.getClass().getName(), this.property, this.st);
    }

    private void whiteSpaceSkip() {
        if (this.cursor < this.end) {
            while (ParseTools.isWhitespace(this.property[this.cursor]) && ++this.cursor < this.end) {
            }
        }
    }

    private boolean scanTo(char c) {
        while (this.cursor < this.end) {
            switch (this.property[this.cursor]) {
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral(this.property[this.cursor], this.property, this.cursor, this.end);
                }
            }
            if (this.property[this.cursor] == c) {
                return false;
            }
            ++this.cursor;
        }
        return true;
    }

    private Object getWithProperty(Object ctx) {
        String nestParm = this.start == this.cursor ? null : new String(this.property, this.start, this.cursor - this.start - 1).trim();
        int st = this.cursor + 1;
        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.property, this.cursor, this.end, '{', AbstractParser.getCurrentThreadParserContext());
        ParseTools.parseWithExpressions(nestParm, this.property, st, this.cursor - st, ctx, this.variableFactory);
        ++this.cursor;
        return ctx;
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() != 0 && (ctx = this.getBeanProperty(ctx, prop)) == null) {
            throw new NullPointerException("null pointer on indexed access for: " + prop);
        }
        this.currType = null;
        int _start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.end || this.scanTo(']')) {
            throw new PropertyAccessException("unterminated '['", this.property, this.cursor);
        }
        prop = new String(this.property, _start, this.cursor++ - _start);
        if (ctx instanceof Map) {
            return ((Map)ctx).get(MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof List) {
            return ((List)ctx).get((Integer)MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof Collection) {
            int count2 = (Integer)MVEL.eval(prop, ctx, this.variableFactory);
            if (count2 > ((Collection)ctx).size()) {
                throw new PropertyAccessException("index [" + count2 + "] out of bounds on collections", this.property, this.cursor);
            }
            Iterator iter = ((Collection)ctx).iterator();
            for (int i2 = 0; i2 < count2; ++i2) {
                iter.next();
            }
            return iter.next();
        }
        if (ctx.getClass().isArray()) {
            return Array.get(ctx, (Integer)MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof CharSequence) {
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)MVEL.eval(prop, ctx, this.variableFactory)));
        }
        try {
            return TypeDescriptor.getClassReference(AbstractParser.getCurrentThreadParserContext(), (Class)ctx, new TypeDescriptor(this.property, this.start, this.length, 0));
        }
        catch (Exception e) {
            throw new PropertyAccessException("illegal use of []: unknown type: " + ctx.getClass().getName(), this.property, this.st, e);
        }
    }

    private Object getCollectionPropertyAO(Object ctx, String prop) throws Exception {
        if (prop.length() != 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        this.currType = null;
        if (ctx == null) {
            return null;
        }
        int _start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.end || this.scanTo(']')) {
            throw new PropertyAccessException("unterminated '['", this.property, this.cursor);
        }
        prop = new String(this.property, _start, this.cursor++ - _start);
        if (ctx instanceof Map) {
            if (PropertyHandlerFactory.hasPropertyHandler(Map.class)) {
                return PropertyHandlerFactory.getPropertyHandler(Map.class).getProperty(prop, ctx, this.variableFactory);
            }
            return ((Map)ctx).get(MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof List) {
            if (PropertyHandlerFactory.hasPropertyHandler(List.class)) {
                return PropertyHandlerFactory.getPropertyHandler(List.class).getProperty(prop, ctx, this.variableFactory);
            }
            return ((List)ctx).get((Integer)MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof Collection) {
            if (PropertyHandlerFactory.hasPropertyHandler(Collection.class)) {
                return PropertyHandlerFactory.getPropertyHandler(Collection.class).getProperty(prop, ctx, this.variableFactory);
            }
            int count2 = (Integer)MVEL.eval(prop, ctx, this.variableFactory);
            if (count2 > ((Collection)ctx).size()) {
                throw new PropertyAccessException("index [" + count2 + "] out of bounds on collections", this.property, this.cursor);
            }
            Iterator iter = ((Collection)ctx).iterator();
            for (int i2 = 0; i2 < count2; ++i2) {
                iter.next();
            }
            return iter.next();
        }
        if (ctx.getClass().isArray()) {
            if (PropertyHandlerFactory.hasPropertyHandler(Array.class)) {
                return PropertyHandlerFactory.getPropertyHandler(Array.class).getProperty(prop, ctx, this.variableFactory);
            }
            return Array.get(ctx, (Integer)MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof CharSequence) {
            if (PropertyHandlerFactory.hasPropertyHandler(CharSequence.class)) {
                return PropertyHandlerFactory.getPropertyHandler(CharSequence.class).getProperty(prop, ctx, this.variableFactory);
            }
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)MVEL.eval(prop, ctx, this.variableFactory)));
        }
        try {
            return TypeDescriptor.getClassReference(AbstractParser.getCurrentThreadParserContext(), (Class)ctx, new TypeDescriptor(this.property, this.start, this.end - this.start, 0));
        }
        catch (Exception e) {
            throw new PropertyAccessException("illegal use of []: unknown type: " + ctx.getClass().getName(), this.property, this.st);
        }
    }

    private Object getMethod(Object ctx, String name2) {
        Class[] parameterTypes;
        Method m;
        Object[] args2;
        int _start = this.cursor;
        String tk = this.cursor != this.end && this.property[this.cursor] == '(' && (this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '(')) - _start > 1 ? new String(this.property, _start + 1, this.cursor - _start - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args2 = ParseTools.EMPTY_OBJ_ARR;
        } else {
            List<char[]> subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            args2 = new Object[subtokens.size()];
            for (int i2 = 0; i2 < subtokens.size(); ++i2) {
                args2[i2] = MVEL.eval(subtokens.get(i2), this.thisReference, this.variableFactory);
            }
        }
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name2)) {
            Object ptr = this.variableFactory.getVariableResolver(name2).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name2 = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name2 = ((MethodStub)ptr).getMethodName();
            } else {
                if (ptr instanceof Function) {
                    ((Function)ptr).checkArgumentCount(args2.length);
                    return ((Function)ptr).call(null, this.thisReference, this.variableFactory, args2);
                }
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name2 + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        }
        if (ctx == null) {
            throw new CompileException("no such method or function: " + name2, this.property, this.cursor);
        }
        Class<?> cls = this.currType != null ? this.currType : (ctx instanceof Class ? (Class)ctx : ctx.getClass());
        this.currType = null;
        if (cls == Proto.ProtoInstance.class) {
            return ((Proto.ProtoInstance)((Object)ctx)).get(name2).call(null, this.thisReference, this.variableFactory, args2);
        }
        Object[] cache = PropertyAccessor.checkMethodCache(cls, PropertyAccessor.createSignature(name2, tk));
        if (cache != null) {
            m = (Method)cache[0];
            parameterTypes = (Class[])cache[1];
        } else {
            m = null;
            parameterTypes = null;
        }
        if (m == null) {
            m = ParseTools.getBestCandidate(args2, name2, cls, cls.getMethods(), false);
            if (m != null) {
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name2, tk), m);
                parameterTypes = m.getParameterTypes();
            }
            if (m == null && (m = ParseTools.getBestCandidate(args2, name2, cls, cls.getClass().getDeclaredMethods(), false)) != null) {
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name2, tk), m);
                parameterTypes = m.getParameterTypes();
            }
        }
        if (m == null && cls != ctx.getClass() && !(ctx instanceof Class) && (m = ParseTools.getBestCandidate(args2, name2, cls = ctx.getClass(), cls.getClass().getDeclaredMethods(), false)) != null) {
            PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name2, tk), m);
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i3 = 0; i3 < args2.length; ++i3) {
                errorBuild.append(args2[i3] != null ? args2[i3].getClass().getName() : null);
                if (i3 >= args2.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name2) && args2.length == 0 && cls.isArray()) {
                return Array.getLength(ctx);
            }
            System.out.println("{ " + new String(this.property) + " }");
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name2 + "(" + errorBuild.toString() + ") [arglength=" + args2.length + "]", this.property, this.st);
        }
        for (int i4 = 0; i4 < args2.length; ++i4) {
            args2[i4] = DataConversion.convert(args2[i4], Varargs.paramTypeVarArgsSafe(parameterTypes, i4, m.isVarArgs()));
        }
        this.currType = ReflectionUtil.toNonPrimitiveType(m.getReturnType());
        try {
            return m.invoke((Object)ctx, Varargs.normalizeArgsForVarArgs(parameterTypes, args2, m.isVarArgs()));
        }
        catch (IllegalAccessException e) {
            try {
                m = ParseTools.getWidenedTarget(m);
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name2, tk), m);
                return m.invoke((Object)ctx, args2);
            }
            catch (Exception e2) {
                throw new PropertyAccessException("unable to invoke method: " + name2, this.property, this.cursor, e2);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PropertyAccessException("unable to invoke method: " + name2, this.property, this.cursor, e);
        }
    }

    private static int createSignature(String name2, String args2) {
        return name2.hashCode() + args2.hashCode();
    }

    private ClassLoader getClassLoader() {
        return this.pCtx != null ? this.pCtx.getClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    protected Object tryStaticAccess() {
        int begin2 = this.cursor;
        try {
            boolean meth = false;
            int last2 = this.end;
            block23: for (int i2 = this.end - 1; i2 > this.start; --i2) {
                switch (this.property[i2]) {
                    case '.': {
                        if (!meth) {
                            try {
                                this.cursor = last2;
                                String test2 = new String(this.property, this.start, this.cursor - this.start);
                                if (MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS && test2.endsWith(".class")) {
                                    test2 = test2.substring(0, test2.length() - 6);
                                }
                                return this.getClassLoader().loadClass(test2);
                            }
                            catch (ClassNotFoundException e) {
                                Class<?> cls = this.getClassLoader().loadClass(new String(this.property, this.start, i2 - this.start));
                                String name2 = new String(this.property, i2 + 1, this.end - i2 - 1);
                                try {
                                    return cls.getField(name2);
                                }
                                catch (NoSuchFieldException nfe) {
                                    for (Method m : cls.getMethods()) {
                                        if (!name2.equals(m.getName())) continue;
                                        return m;
                                    }
                                    return null;
                                }
                            }
                        }
                        meth = false;
                        last2 = i2;
                        continue block23;
                    }
                    case '}': {
                        char s2;
                        --i2;
                        int d = 1;
                        while (i2 > 0 && d != 0) {
                            switch (this.property[i2]) {
                                case '}': {
                                    ++d;
                                    break;
                                }
                                case '{': {
                                    --d;
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    s2 = this.property[i2];
                                    while (i2 > 0 && this.property[i2] != s2 && this.property[i2 - 1] != '\\') {
                                        --i2;
                                    }
                                    break;
                                }
                            }
                            --i2;
                        }
                        continue block23;
                    }
                    case ')': {
                        char s2;
                        --i2;
                        int d = 1;
                        while (i2 > 0 && d != 0) {
                            switch (this.property[i2]) {
                                case ')': {
                                    ++d;
                                    break;
                                }
                                case '(': {
                                    --d;
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    s2 = this.property[i2];
                                    while (i2 > 0 && this.property[i2] != s2 && this.property[i2 - 1] != '\\') {
                                        --i2;
                                    }
                                    break;
                                }
                            }
                            --i2;
                        }
                        meth = true;
                        last2 = i2++;
                        continue block23;
                    }
                    case '\'': {
                        while (--i2 > 0 && (this.property[i2] != '\'' || this.property[i2 - 1] == '\\')) {
                        }
                        continue block23;
                    }
                    case '\"': {
                        while (--i2 > 0 && (this.property[i2] != '\"' || this.property[i2 - 1] == '\\')) {
                        }
                        continue block23;
                    }
                }
            }
        }
        catch (Exception cnfe) {
            this.cursor = begin2;
        }
        return null;
    }
}

