/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.elasticsearch.common.Numbers;

public class UidField
extends AbstractField {
    private String uid;
    private long version;
    private final UidPayloadTokenStream tokenStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocIdAndVersion loadDocIdAndVersion(IndexReader subReader, int docStart, Term term) {
        int docId = -1;
        TermPositions uid2 = null;
        try {
            uid2 = subReader.termPositions(term);
            if (!uid2.next()) {
                DocIdAndVersion docIdAndVersion = null;
                return docIdAndVersion;
            }
            do {
                docId = uid2.doc();
                uid2.nextPosition();
                if (!uid2.isPayloadAvailable() || uid2.getPayloadLength() < 8) continue;
                byte[] payload = uid2.getPayload(new byte[8], 0);
                DocIdAndVersion e = new DocIdAndVersion(docId, Numbers.bytesToLong(payload), subReader, docStart);
                return e;
            } while (uid2.next());
            DocIdAndVersion payload = new DocIdAndVersion(docId, -2L, subReader, docStart);
            return payload;
        }
        catch (Exception e) {
            DocIdAndVersion docIdAndVersion = new DocIdAndVersion(docId, -2L, subReader, docStart);
            return docIdAndVersion;
        }
        finally {
            if (uid2 != null) {
                try {
                    uid2.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long loadVersion(IndexReader reader, Term term) {
        TermPositions uid2 = null;
        try {
            uid2 = reader.termPositions(term);
            if (!uid2.next()) {
                long l = -1L;
                return l;
            }
            do {
                uid2.nextPosition();
                if (!uid2.isPayloadAvailable() || uid2.getPayloadLength() < 8) continue;
                byte[] payload = uid2.getPayload(new byte[8], 0);
                long l = Numbers.bytesToLong(payload);
                return l;
            } while (uid2.next());
            long l = -2L;
            return l;
        }
        catch (Exception e) {
            long l = -2L;
            return l;
        }
        finally {
            if (uid2 != null) {
                try {
                    uid2.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public UidField(String name2, String uid2, long version) {
        super(name2, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
        this.uid = uid2;
        this.version = version;
        this.indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        this.tokenStream = new UidPayloadTokenStream(this);
    }

    @Override
    public void setIndexOptions(FieldInfo.IndexOptions indexOptions) {
    }

    @Override
    public void setOmitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
    }

    public String uid() {
        return this.uid;
    }

    public void setUid(String uid2) {
        this.uid = uid2;
    }

    @Override
    public String stringValue() {
        return this.uid;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public TokenStream tokenStreamValue() {
        return this.tokenStream;
    }

    public static final class UidPayloadTokenStream
    extends TokenStream {
        private final PayloadAttribute payloadAttribute = this.addAttribute(PayloadAttribute.class);
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
        private final UidField field;
        private boolean added = false;

        public UidPayloadTokenStream(UidField field2) {
            this.field = field2;
        }

        @Override
        public void reset() throws IOException {
            this.added = false;
        }

        @Override
        public final boolean incrementToken() throws IOException {
            if (this.added) {
                return false;
            }
            this.termAtt.setLength(0);
            this.termAtt.append(this.field.uid);
            this.payloadAttribute.setPayload(new Payload(Numbers.longToBytes(this.field.version())));
            this.added = true;
            return true;
        }
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final int docStart;
        public final long version;
        public final IndexReader reader;

        public DocIdAndVersion(int docId, long version, IndexReader reader, int docStart) {
            this.docId = docId;
            this.version = version;
            this.reader = reader;
            this.docStart = docStart;
        }
    }
}

