/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.store;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexOutput;

public class ChecksumIndexOutput
extends IndexOutput {
    private final IndexOutput out;
    private final Checksum digest;

    public ChecksumIndexOutput(IndexOutput out, Checksum digest2) {
        this.out = out;
        this.digest = digest2;
    }

    public Checksum digest() {
        return this.digest;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
        this.digest.update(b);
    }

    @Override
    public void setLength(long length2) throws IOException {
        this.out.setLength(length2);
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void writeBytes(byte[] b, int offset2, int length2) throws IOException {
        this.out.writeBytes(b, offset2, length2);
        this.digest.update(b, offset2, length2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public long getFilePointer() {
        return this.out.getFilePointer();
    }

    @Override
    public void seek(long pos2) throws IOException {
        this.out.seek(pos2);
    }

    @Override
    public long length() throws IOException {
        return this.out.length();
    }
}

