/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.lucene.spatial.prefix.tree.Node;

public abstract class SpatialPrefixTree {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final int maxLevels;
    protected final SpatialContext ctx;
    private transient Node worldNode;

    public SpatialPrefixTree(SpatialContext ctx, int maxLevels) {
        assert (maxLevels > 0);
        this.ctx = ctx;
        this.maxLevels = maxLevels;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(maxLevels:" + this.maxLevels + ",ctx:" + this.ctx + ")";
    }

    public abstract int getLevelForDistance(double var1);

    public Node getWorldNode() {
        if (this.worldNode == null) {
            this.worldNode = this.getNode("");
        }
        return this.worldNode;
    }

    public abstract Node getNode(String var1);

    public abstract Node getNode(byte[] var1, int var2, int var3);

    public final Node getNode(byte[] bytes2, int offset2, int len, Node target) {
        if (target == null) {
            return this.getNode(bytes2, offset2, len);
        }
        target.reset(bytes2, offset2, len);
        return target;
    }

    protected Node getNode(Point p2, int level2) {
        return this.getNodes(p2, level2, false).get(0);
    }

    public List<Node> getNodes(Shape shape, int detailLevel, boolean inclParents) {
        ArrayList<Node> cells;
        if (detailLevel > this.maxLevels) {
            throw new IllegalArgumentException("detailLevel > maxLevels");
        }
        if (shape instanceof Point) {
            int initialCapacity = inclParents ? 1 + detailLevel : 1;
            cells = new ArrayList(initialCapacity);
            this.recursiveGetNodes(this.getWorldNode(), (Point)shape, detailLevel, true, cells);
            assert (cells.size() == initialCapacity);
        } else {
            cells = new ArrayList<Node>(inclParents ? 1024 : 512);
            this.recursiveGetNodes(this.getWorldNode(), shape, detailLevel, inclParents, cells);
        }
        if (inclParents) {
            Node c = (Node)cells.remove(0);
            assert (c.getLevel() == 0);
        }
        return cells;
    }

    private void recursiveGetNodes(Node node, Shape shape, int detailLevel, boolean inclParents, Collection<Node> result2) {
        if (node.isLeaf()) {
            result2.add(node);
            return;
        }
        Collection<Node> subCells = node.getSubCells(shape);
        if (node.getLevel() == detailLevel - 1) {
            if (subCells.size() < node.getSubCellsSize()) {
                if (inclParents) {
                    result2.add(node);
                }
                for (Node subCell : subCells) {
                    subCell.setLeaf();
                }
                result2.addAll(subCells);
            } else {
                node.setLeaf();
                result2.add(node);
            }
        } else {
            if (inclParents) {
                result2.add(node);
            }
            for (Node subCell : subCells) {
                this.recursiveGetNodes(subCell, shape, detailLevel, inclParents, result2);
            }
        }
    }

    private void recursiveGetNodes(Node node, Point point, int detailLevel, boolean inclParents, Collection<Node> result2) {
        if (inclParents) {
            result2.add(node);
        }
        Node pCell = node.getSubCell(point);
        if (node.getLevel() == detailLevel - 1) {
            pCell.setLeaf();
            result2.add(pCell);
        } else {
            this.recursiveGetNodes(pCell, point, detailLevel, inclParents, result2);
        }
    }

    protected final List<Node> getNodesAltPoint(Point p2, int detailLevel, boolean inclParents) {
        Node cell = this.getNode(p2, detailLevel);
        if (!inclParents) {
            return Collections.singletonList(cell);
        }
        String endToken = cell.getTokenString();
        assert (endToken.length() == detailLevel);
        ArrayList<Node> cells = new ArrayList<Node>(detailLevel);
        for (int i2 = 1; i2 < detailLevel; ++i2) {
            cells.add(this.getNode(endToken.substring(0, i2)));
        }
        cells.add(cell);
        return cells;
    }

    public static List<String> nodesToTokenStrings(Collection<Node> nodes) {
        ArrayList<String> tokens = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            String token = node.getTokenString();
            if (node.isLeaf()) {
                tokens.add(token + '+');
                continue;
            }
            tokens.add(token);
        }
        return tokens;
    }
}

