/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.lucene.docset.DocSet;

public class OpenBitDocSet
extends DocSet {
    private final OpenBitSet set;

    public OpenBitDocSet(OpenBitSet set) {
        this.set = set;
    }

    public OpenBitDocSet(int numBits) {
        this.set = new OpenBitSetDISI(numBits);
    }

    public OpenBitDocSet(DocIdSetIterator disi, int numBits) throws IOException {
        this.set = new OpenBitSetDISI(disi, numBits);
    }

    @Override
    public int length() {
        return this.set.length();
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public OpenBitSet set() {
        return this.set;
    }

    @Override
    public boolean get(int doc) {
        return this.set.fastGet(doc);
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return this.set.iterator();
    }

    @Override
    public long sizeInBytes() {
        return this.set.getBits().length * 8 + RamUsage.NUM_BYTES_ARRAY_HEADER + 4;
    }
}

