/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.field.data.FieldDataType;

public class Lucene {
    public static final Version VERSION;
    public static final Version ANALYZER_VERSION;
    public static final Version QUERYPARSER_VERSION;
    public static final NamedAnalyzer STANDARD_ANALYZER;
    public static final NamedAnalyzer KEYWORD_ANALYZER;
    public static final int NO_DOC = -1;
    public static ScoreDoc[] EMPTY_SCORE_DOCS;
    public static final int BATCH_ENUM_DOCS = 32;
    private static final Field segmentReaderSegmentInfoField;

    public static Version parseVersion(@Nullable String version, Version defaultVersion, ESLogger logger) {
        if (version == null) {
            return defaultVersion;
        }
        if ("3.6".equals(version)) {
            return Version.LUCENE_36;
        }
        if ("3.5".equals(version)) {
            return Version.LUCENE_35;
        }
        if ("3.4".equals(version)) {
            return Version.LUCENE_34;
        }
        if ("3.3".equals(version)) {
            return Version.LUCENE_33;
        }
        if ("3.2".equals(version)) {
            return Version.LUCENE_32;
        }
        if ("3.1".equals(version)) {
            return Version.LUCENE_31;
        }
        if ("3.0".equals(version)) {
            return Version.LUCENE_30;
        }
        logger.warn("no version match {}, default to {}", new Object[]{version, defaultVersion});
        return defaultVersion;
    }

    public static long count(IndexSearcher searcher, Query query) throws IOException {
        TotalHitCountCollector countCollector = new TotalHitCountCollector();
        if (!(query instanceof ConstantScoreQuery)) {
            query = new ConstantScoreQuery(query);
        }
        searcher.search(query, countCollector);
        return countCollector.getTotalHits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int docId(IndexReader reader, Term term) throws IOException {
        TermDocs termDocs = reader.termDocs(term);
        try {
            if (termDocs.next()) {
                int n = termDocs.doc();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            termDocs.close();
        }
    }

    public static boolean safeClose(IndexWriter writer) {
        if (writer == null) {
            return true;
        }
        try {
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static TopDocs readTopDocs(StreamInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            int totalHits = in.readVInt();
            float maxScore = in.readFloat();
            SortField[] fields2 = new SortField[in.readVInt()];
            for (int i2 = 0; i2 < fields2.length; ++i2) {
                String field2 = null;
                if (in.readBoolean()) {
                    field2 = in.readUTF();
                }
                fields2[i2] = new SortField(field2, in.readVInt(), in.readBoolean());
            }
            ScoreDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i3 = 0; i3 < fieldDocs.length; ++i3) {
                Object[] cFields = new Comparable[in.readVInt()];
                for (int j = 0; j < cFields.length; ++j) {
                    byte type2 = in.readByte();
                    if (type2 == 0) {
                        cFields[j] = null;
                        continue;
                    }
                    if (type2 == 1) {
                        cFields[j] = in.readUTF();
                        continue;
                    }
                    if (type2 == 2) {
                        cFields[j] = in.readInt();
                        continue;
                    }
                    if (type2 == 3) {
                        cFields[j] = in.readLong();
                        continue;
                    }
                    if (type2 == 4) {
                        cFields[j] = Float.valueOf(in.readFloat());
                        continue;
                    }
                    if (type2 == 5) {
                        cFields[j] = in.readDouble();
                        continue;
                    }
                    if (type2 == 6) {
                        cFields[j] = in.readByte();
                        continue;
                    }
                    if (type2 == 7) {
                        cFields[j] = in.readShort();
                        continue;
                    }
                    if (type2 == 8) {
                        cFields[j] = in.readBoolean();
                        continue;
                    }
                    throw new IOException("Can't match type [" + type2 + "]");
                }
                fieldDocs[i3] = new FieldDoc(in.readVInt(), in.readFloat(), cFields);
            }
            return new TopFieldDocs(totalHits, fieldDocs, fields2, maxScore);
        }
        int totalHits = in.readVInt();
        float maxScore = in.readFloat();
        ScoreDoc[] scoreDocs = new ScoreDoc[in.readVInt()];
        for (int i4 = 0; i4 < scoreDocs.length; ++i4) {
            scoreDocs[i4] = new ScoreDoc(in.readVInt(), in.readFloat());
        }
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public static void writeTopDocs(StreamOutput out, TopDocs topDocs, int from) throws IOException {
        if (topDocs.scoreDocs.length - from < 0) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (topDocs instanceof TopFieldDocs) {
            out.writeBoolean(true);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topFieldDocs.fields.length);
            for (SortField sortField : topFieldDocs.fields) {
                if (sortField.getField() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(sortField.getField());
                }
                if (sortField.getComparatorSource() != null) {
                    out.writeVInt(((FieldDataType.ExtendedFieldComparatorSource)sortField.getComparatorSource()).reducedType());
                } else {
                    out.writeVInt(sortField.getType());
                }
                out.writeBoolean(sortField.getReverse());
            }
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index2 = 0;
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                if (index2++ < from) continue;
                FieldDoc fieldDoc = (FieldDoc)doc;
                out.writeVInt(fieldDoc.fields.length);
                for (Object field2 : fieldDoc.fields) {
                    if (field2 == null) {
                        out.writeByte((byte)0);
                        continue;
                    }
                    Class<?> type2 = field2.getClass();
                    if (type2 == String.class) {
                        out.writeByte((byte)1);
                        out.writeUTF((String)field2);
                        continue;
                    }
                    if (type2 == Integer.class) {
                        out.writeByte((byte)2);
                        out.writeInt((Integer)field2);
                        continue;
                    }
                    if (type2 == Long.class) {
                        out.writeByte((byte)3);
                        out.writeLong((Long)field2);
                        continue;
                    }
                    if (type2 == Float.class) {
                        out.writeByte((byte)4);
                        out.writeFloat(((Float)field2).floatValue());
                        continue;
                    }
                    if (type2 == Double.class) {
                        out.writeByte((byte)5);
                        out.writeDouble((Double)field2);
                        continue;
                    }
                    if (type2 == Byte.class) {
                        out.writeByte((byte)6);
                        out.writeByte((Byte)field2);
                        continue;
                    }
                    if (type2 == Short.class) {
                        out.writeByte((byte)7);
                        out.writeShort((Short)field2);
                        continue;
                    }
                    if (type2 == Boolean.class) {
                        out.writeByte((byte)8);
                        out.writeBoolean((Boolean)field2);
                        continue;
                    }
                    throw new IOException("Can't handle sort field value of type [" + type2 + "]");
                }
                out.writeVInt(doc.doc);
                out.writeFloat(doc.score);
            }
        } else {
            out.writeBoolean(false);
            out.writeVInt(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topDocs.scoreDocs.length - from);
            int index3 = 0;
            for (ScoreDoc doc : topDocs.scoreDocs) {
                if (index3++ < from) continue;
                out.writeVInt(doc.doc);
                out.writeFloat(doc.score);
            }
        }
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        float value2 = in.readFloat();
        String description = in.readUTF();
        Explanation explanation = new Explanation(value2, description);
        if (in.readBoolean()) {
            int size2 = in.readVInt();
            for (int i2 = 0; i2 < size2; ++i2) {
                explanation.addDetail(Lucene.readExplanation(in));
            }
        }
        return explanation;
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeFloat(explanation.getValue());
        out.writeUTF(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        if (subExplanations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(subExplanations.length);
            for (Explanation subExp : subExplanations) {
                Lucene.writeExplanation(out, subExp);
            }
        }
    }

    public static SegmentInfo getSegmentInfo(SegmentReader reader) {
        try {
            return (SegmentInfo)segmentReaderSegmentInfoField.get(reader);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Lucene() {
    }

    public static final boolean indexExists(final Directory directory) {
        try {
            new SegmentInfos.FindSegmentsFile(directory){

                @Override
                protected Object doBody(String segmentFileName) throws IOException {
                    block2: {
                        try {
                            new SegmentInfos().read(directory, segmentFileName);
                        }
                        catch (FileNotFoundException ex) {
                            if (directory.fileExists(segmentFileName)) break block2;
                            throw ex;
                        }
                    }
                    return null;
                }
            }.run();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    static {
        ANALYZER_VERSION = VERSION = Version.LUCENE_36;
        QUERYPARSER_VERSION = VERSION;
        STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, new StandardAnalyzer(ANALYZER_VERSION));
        KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, new KeywordAnalyzer());
        EMPTY_SCORE_DOCS = new ScoreDoc[0];
        Field segmentReaderSegmentInfoFieldX = null;
        try {
            segmentReaderSegmentInfoFieldX = SegmentReader.class.getDeclaredField("si");
            segmentReaderSegmentInfoFieldX.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        segmentReaderSegmentInfoField = segmentReaderSegmentInfoFieldX;
    }

    public static class ExistsCollector
    extends Collector {
        private boolean exists;

        public void reset() {
            this.exists = false;
        }

        public boolean exists() {
            return this.exists;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.exists = false;
        }

        @Override
        public void collect(int doc) throws IOException {
            this.exists = true;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

