/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.elasticsearch.common.logging.support.AbstractESLogger;

public class Log4jESLogger
extends AbstractESLogger {
    private final Logger logger;

    public Log4jESLogger(String prefix, Logger logger) {
        super(prefix);
        this.logger = logger;
    }

    @Override
    public void setLevel(String level2) {
        if ("error".equalsIgnoreCase(level2)) {
            this.logger.setLevel(Level.ERROR);
        } else if ("warn".equalsIgnoreCase(level2)) {
            this.logger.setLevel(Level.WARN);
        } else if ("info".equalsIgnoreCase(level2)) {
            this.logger.setLevel(Level.INFO);
        } else if ("debug".equalsIgnoreCase(level2)) {
            this.logger.setLevel(Level.DEBUG);
        } else if ("trace".equalsIgnoreCase(level2)) {
            this.logger.setLevel(Level.TRACE);
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Level.ERROR);
    }

    @Override
    protected void internalTrace(String msg) {
        this.logger.trace(msg);
    }

    @Override
    protected void internalTrace(String msg, Throwable cause2) {
        this.logger.trace(msg, cause2);
    }

    @Override
    protected void internalDebug(String msg) {
        this.logger.debug(msg);
    }

    @Override
    protected void internalDebug(String msg, Throwable cause2) {
        this.logger.debug(msg, cause2);
    }

    @Override
    protected void internalInfo(String msg) {
        this.logger.info(msg);
    }

    @Override
    protected void internalInfo(String msg, Throwable cause2) {
        this.logger.info(msg, cause2);
    }

    @Override
    protected void internalWarn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    protected void internalWarn(String msg, Throwable cause2) {
        this.logger.warn(msg, cause2);
    }

    @Override
    protected void internalError(String msg) {
        this.logger.error(msg);
    }

    @Override
    protected void internalError(String msg, Throwable cause2) {
        this.logger.error(msg, cause2);
    }
}

