/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.elasticsearch.common.jackson.core.JsonEncoding;
import org.elasticsearch.common.jackson.core.JsonFactory;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.format.InputAccessor;
import org.elasticsearch.common.jackson.core.format.MatchStrength;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.yaml.ModuleVersion;
import org.elasticsearch.common.jackson.dataformat.yaml.UTF8Reader;
import org.elasticsearch.common.jackson.dataformat.yaml.UTF8Writer;
import org.elasticsearch.common.jackson.dataformat.yaml.YAMLGenerator;
import org.elasticsearch.common.jackson.dataformat.yaml.YAMLParser;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.DumperOptions;

public class YAMLFactory
extends JsonFactory {
    public static final String FORMAT_NAME_YAML = "YAML";
    static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLParser.Feature.collectDefaults();
    static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLGenerator.Feature.collectDefaults();
    static final byte UTF8_BOM_1 = -17;
    static final byte UTF8_BOM_2 = -69;
    static final byte UTF8_BOM_3 = -65;
    protected int _yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
    protected int _yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    protected DumperOptions _outputOptions;
    protected Integer[] _version;
    protected final Charset UTF8 = Charset.forName("UTF-8");

    public YAMLFactory() {
        this(null);
    }

    public YAMLFactory(ObjectCodec oc) {
        super(oc);
        this._outputOptions = YAMLFactory._defaultOptions();
        DumperOptions.Version version = this._outputOptions.getVersion();
        this._version = version == null ? null : version.getArray();
    }

    private static DumperOptions _defaultOptions() {
        DumperOptions opt = new DumperOptions();
        opt.setCanonical(false);
        opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return opt;
    }

    @Override
    public Version version() {
        return ModuleVersion.instance.version();
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b = acc.nextByte();
        if (b == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
        }
        if (b == 45 && acc.hasMoreBytes() && acc.nextByte() == 45 && acc.hasMoreBytes() && acc.nextByte() == 45) {
            return MatchStrength.FULL_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final YAMLFactory configure(YAMLParser.Feature f, boolean state2) {
        if (state2) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public YAMLFactory enable(YAMLParser.Feature f) {
        this._yamlParserFeatures |= f.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLParser.Feature f) {
        this._yamlParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLParser.Feature f) {
        return (this._yamlParserFeatures & f.getMask()) != 0;
    }

    public final YAMLFactory configure(YAMLGenerator.Feature f, boolean state2) {
        if (state2) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public YAMLFactory enable(YAMLGenerator.Feature f) {
        this._yamlGeneratorFeatures |= f.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLGenerator.Feature f) {
        this._yamlGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator.Feature f) {
        return (this._yamlGeneratorFeatures & f.getMask()) != 0;
    }

    @Override
    public YAMLParser createParser(String content) throws IOException, JsonParseException {
        Reader r = new StringReader(content);
        IOContext ctxt = this._createContext(r, true);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    @Override
    public YAMLParser createParser(File f) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(f, true);
        InputStream in = new FileInputStream(f);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public YAMLParser createParser(URL url) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(url, true);
        InputStream in = this._optimizedStreamFromURL(url);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public YAMLParser createParser(InputStream in) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(in, false);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public JsonParser createParser(Reader r) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(r, false);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    @Override
    public YAMLParser createParser(byte[] data2) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data2, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data2, 0, data2.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data2, 0, data2.length, ctxt);
    }

    @Override
    public YAMLParser createParser(byte[] data2, int offset2, int len) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data2, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data2, offset2, len)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data2, offset2, len, ctxt);
    }

    @Override
    public YAMLParser createJsonParser(String content) throws IOException, JsonParseException {
        Reader r = new StringReader(content);
        IOContext ctxt = this._createContext(r, true);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    @Override
    public YAMLParser createJsonParser(File f) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(f, true);
        InputStream in = new FileInputStream(f);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public YAMLParser createJsonParser(URL url) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(url, true);
        InputStream in = this._optimizedStreamFromURL(url);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public YAMLParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(in, false);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public JsonParser createJsonParser(Reader r) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(r, false);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    @Override
    public YAMLParser createJsonParser(byte[] data2) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data2, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data2, 0, data2.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data2, 0, data2.length, ctxt);
    }

    @Override
    public YAMLParser createJsonParser(byte[] data2, int offset2, int len) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data2, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data2, offset2, len)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data2, offset2, len, ctxt);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this._createGenerator(this._createWriter(out, JsonEncoding.UTF8, ctxt), ctxt);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this._createGenerator(this._createWriter(out, JsonEncoding.UTF8, ctxt), ctxt);
    }

    @Override
    public YAMLGenerator createGenerator(Writer out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        if (this._outputDecorator != null) {
            out = this._outputDecorator.decorate(ctxt, out);
        }
        return this._createGenerator(out, ctxt);
    }

    @Override
    public YAMLGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this.createGenerator(out, enc);
    }

    @Override
    public YAMLGenerator createJsonGenerator(OutputStream out) throws IOException {
        return this.createGenerator(out);
    }

    @Override
    public YAMLGenerator createJsonGenerator(Writer out) throws IOException {
        return this.createGenerator(out);
    }

    @Override
    protected YAMLParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(in, null, ctxt);
        return new YAMLParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, r);
    }

    @Override
    protected YAMLParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return new YAMLParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, r);
    }

    @Override
    protected YAMLParser _createParser(byte[] data2, int offset2, int len, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(data2, offset2, len, null, ctxt);
        return new YAMLParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, r);
    }

    @Override
    protected YAMLParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return this._createParser(in, ctxt);
    }

    @Override
    protected JsonParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return this._createParser(r, ctxt);
    }

    @Override
    protected YAMLParser _createJsonParser(byte[] data2, int offset2, int len, IOContext ctxt) throws IOException, JsonParseException {
        return this._createParser(data2, offset2, len, ctxt);
    }

    @Override
    protected YAMLGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        int feats = this._yamlGeneratorFeatures;
        YAMLGenerator gen = new YAMLGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out, this._outputOptions, this._version);
        return gen;
    }

    @Override
    protected YAMLGenerator _createJsonGenerator(Writer out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    @Override
    protected YAMLGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(new UTF8Writer(out), ctxt);
    }

    @Override
    @Deprecated
    protected YAMLGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createUTF8Generator(out, ctxt);
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(out);
        }
        return new OutputStreamWriter(out, enc.getJavaName());
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(in, autoClose);
        }
        return new InputStreamReader(in, enc.getJavaName());
    }

    protected Reader _createReader(byte[] data2, int offset2, int len, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(data2, offset2, len, true);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data2, offset2, len);
        return new InputStreamReader((InputStream)in, enc.getJavaName());
    }
}

