/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core.json;

import org.elasticsearch.common.jackson.core.JsonLocation;
import org.elasticsearch.common.jackson.core.JsonStreamContext;
import org.elasticsearch.common.jackson.core.io.CharTypes;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected JsonReadContext _child = null;

    public JsonReadContext(JsonReadContext parent, int type2, int lineNr, int colNr) {
        this._type = type2;
        this._parent = parent;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._index = -1;
    }

    protected void reset(int type2, int lineNr, int colNr) {
        this._type = type2;
        this._index = -1;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._currentName = null;
    }

    public static JsonReadContext createRootContext(int lineNr, int colNr) {
        return new JsonReadContext(null, 0, lineNr, colNr);
    }

    public static JsonReadContext createRootContext() {
        return new JsonReadContext(null, 0, 1, 0);
    }

    public JsonReadContext createChildArrayContext(int lineNr, int colNr) {
        JsonReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new JsonReadContext(this, 1, lineNr, colNr);
            return ctxt;
        }
        ctxt.reset(1, lineNr, colNr);
        return ctxt;
    }

    public JsonReadContext createChildObjectContext(int lineNr, int colNr) {
        JsonReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new JsonReadContext(this, 2, lineNr, colNr);
            return ctxt;
        }
        ctxt.reset(2, lineNr, colNr);
        return ctxt;
    }

    public String getCurrentName() {
        return this._currentName;
    }

    public JsonReadContext getParent() {
        return this._parent;
    }

    public JsonLocation getStartLocation(Object srcRef) {
        long totalChars = -1L;
        return new JsonLocation(srcRef, totalChars, this._lineNr, this._columnNr);
    }

    public boolean expectComma() {
        int ix = ++this._index;
        return this._type != 0 && ix > 0;
    }

    public void setCurrentName(String name2) {
        this._currentName = name2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this._currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted(sb, this._currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }
}

