/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.text.Text;

public abstract class StreamOutput
extends OutputStream {
    private Version version = Version.CURRENT;
    private static byte ZERO = 0;
    private static byte ONE = 1;

    public Version getVersion() {
        return this.version;
    }

    public StreamOutput setVersion(Version version) {
        this.version = version;
        return this;
    }

    public boolean seekPositionSupported() {
        return false;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length2) throws IOException {
        this.writeBytes(b, 0, length2);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeBytesReference(@Nullable BytesReference bytes2) throws IOException {
        if (bytes2 == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes2.length());
        bytes2.writeTo(this);
    }

    public final void writeShort(short v) throws IOException {
        this.writeByte((byte)(v >> 8));
        this.writeByte((byte)v);
    }

    public void writeInt(int i2) throws IOException {
        this.writeByte((byte)(i2 >> 24));
        this.writeByte((byte)(i2 >> 16));
        this.writeByte((byte)(i2 >> 8));
        this.writeByte((byte)i2);
    }

    public void writeVInt(int i2) throws IOException {
        while ((i2 & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i2 & 0x7F | 0x80));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public void writeLong(long i2) throws IOException {
        this.writeInt((int)(i2 >> 32));
        this.writeInt((int)i2);
    }

    public void writeVLong(long i2) throws IOException {
        while ((i2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i2 & 0x7FL | 0x80L));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    @Deprecated
    public void writeOptionalUTF(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeUTF(str);
        }
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(str);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes() && this.seekPositionSupported()) {
            long pos1 = this.position();
            this.seek(pos1 + 4L);
            UTF8StreamWriter utf8StreamWriter = CachedStreamOutput.utf8StreamWriter();
            utf8StreamWriter.setOutput(this);
            utf8StreamWriter.write(text.string());
            utf8StreamWriter.close();
            long pos2 = this.position();
            this.seek(pos1);
            this.writeInt((int)(pos2 - pos1 - 4L));
            this.seek(pos2);
        } else {
            BytesReference bytes2 = text.bytes();
            this.writeInt(bytes2.length());
            bytes2.writeTo(this);
        }
    }

    public void writeString(String str) throws IOException {
        int charCount = str.length();
        this.writeVInt(charCount);
        for (int i2 = 0; i2 < charCount; ++i2) {
            char c = str.charAt(i2);
            if (c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    @Deprecated
    public void writeUTF(String str) throws IOException {
        this.writeString(str);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s2 : array) {
            this.writeString(s2);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeVInt(array.length);
            for (String s2 : array) {
                this.writeString(s2);
            }
        }
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeGenericValue(@Nullable Object value2) throws IOException {
        if (value2 == null) {
            this.writeByte((byte)-1);
            return;
        }
        Class<?> type2 = value2.getClass();
        if (type2 == String.class) {
            this.writeByte((byte)0);
            this.writeString((String)value2);
        } else if (type2 == Integer.class) {
            this.writeByte((byte)1);
            this.writeInt((Integer)value2);
        } else if (type2 == Long.class) {
            this.writeByte((byte)2);
            this.writeLong((Long)value2);
        } else if (type2 == Float.class) {
            this.writeByte((byte)3);
            this.writeFloat(((Float)value2).floatValue());
        } else if (type2 == Double.class) {
            this.writeByte((byte)4);
            this.writeDouble((Double)value2);
        } else if (type2 == Boolean.class) {
            this.writeByte((byte)5);
            this.writeBoolean((Boolean)value2);
        } else if (type2 == byte[].class) {
            this.writeByte((byte)6);
            this.writeVInt(((byte[])value2).length);
            this.writeBytes((byte[])value2);
        } else if (value2 instanceof List) {
            this.writeByte((byte)7);
            List list2 = (List)value2;
            this.writeVInt(list2.size());
            for (Object o : list2) {
                this.writeGenericValue(o);
            }
        } else if (value2 instanceof Object[]) {
            this.writeByte((byte)8);
            Object[] list3 = (Object[])value2;
            this.writeVInt(list3.length);
            for (Object o : list3) {
                this.writeGenericValue(o);
            }
        } else if (value2 instanceof Map) {
            if (value2 instanceof LinkedHashMap) {
                this.writeByte((byte)9);
            } else {
                this.writeByte((byte)10);
            }
            Map map = (Map)value2;
            this.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.writeString((String)entry.getKey());
                this.writeGenericValue(entry.getValue());
            }
        } else if (type2 == Byte.class) {
            this.writeByte((byte)11);
            this.writeByte((Byte)value2);
        } else if (type2 == Date.class) {
            this.writeByte((byte)12);
            this.writeLong(((Date)value2).getTime());
        } else if (value2 instanceof ReadableInstant) {
            this.writeByte((byte)13);
            this.writeLong(((ReadableInstant)value2).getMillis());
        } else if (value2 instanceof BytesReference) {
            this.writeByte((byte)14);
            this.writeBytesReference((BytesReference)value2);
        } else if (value2 instanceof Text) {
            this.writeByte((byte)15);
            this.writeText((Text)value2);
        } else if (type2 == Short.class) {
            this.writeByte((byte)16);
            this.writeShort((Short)value2);
        } else {
            throw new IOException("Can't write type [" + type2 + "]");
        }
    }
}

