/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.io.stream.StreamInput;

public class InputStreamStreamInput
extends StreamInput {
    private final InputStream is;

    public InputStreamStreamInput(InputStream is) {
        this.is = is;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public void readBytes(byte[] b, int offset2, int len) throws IOException {
        int count2;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count2) {
            count2 = this.is.read(b, offset2 + n, len - n);
            if (count2 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }
}

