/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.io.stream.AdapterStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.trove.map.hash.TIntObjectHashMap;

public class HandlesStreamInput
extends AdapterStreamInput {
    private final TIntObjectHashMap<String> handles = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> identityHandles = new TIntObjectHashMap();

    HandlesStreamInput() {
    }

    public HandlesStreamInput(StreamInput in) {
        super(in);
    }

    @Override
    @Deprecated
    public String readUTF() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle = this.in.readVInt();
            String s2 = this.in.readUTF();
            this.handles.put(handle, s2);
            return s2;
        }
        if (b == 1) {
            return this.handles.get(this.in.readVInt());
        }
        if (b == 2) {
            int handle = this.in.readVInt();
            String s3 = this.in.readUTF();
            this.identityHandles.put(handle, s3);
            return s3;
        }
        if (b == 3) {
            return this.identityHandles.get(this.in.readVInt());
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public String readString() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle = this.in.readVInt();
            String s2 = this.in.readString();
            this.handles.put(handle, s2);
            return s2;
        }
        if (b == 1) {
            return this.handles.get(this.in.readVInt());
        }
        if (b == 2) {
            int handle = this.in.readVInt();
            String s3 = this.in.readString();
            this.identityHandles.put(handle, s3);
            return s3;
        }
        if (b == 3) {
            return this.identityHandles.get(this.in.readVInt());
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.handles.clear();
        this.identityHandles.clear();
    }

    @Override
    public void reset(StreamInput in) {
        super.reset(in);
        this.handles.clear();
        this.identityHandles.clear();
    }

    public void cleanHandles() {
        this.handles.clear();
        this.identityHandles.clear();
    }
}

