/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelInputStream
extends InputStream {
    private final FileChannel channel;
    private long position;
    private long length;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1 = null;
    private long markPosition;

    public FileChannelInputStream(FileChannel channel, long position, long length2) {
        this.channel = channel;
        this.position = position;
        this.markPosition = position;
        this.length = position + length2;
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        if ((n = this.read(this.b1)) == 1) {
            return this.b1[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bs, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.length - this.position < (long)len) {
            len = (int)(this.length - this.position);
        }
        if (len == 0) {
            return -1;
        }
        ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
        bb.limit(Math.min(off + len, bb.capacity()));
        bb.position(off);
        this.bb = bb;
        this.bs = bs;
        int read2 = this.channel.read(bb, this.position);
        if (read2 > 0) {
            this.position += (long)read2;
        }
        return read2;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markPosition = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.position = this.markPosition;
    }
}

