/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.BytesStream;

public class FastByteArrayOutputStream
extends OutputStream
implements BytesStream {
    protected byte[] buf;
    protected int count;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size2) {
        if (size2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size2);
        }
        this.buf = new byte[size2];
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Bytes.oversize(newcount, 1));
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Bytes.oversize(newcount, 1));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    @Override
    public BytesReference bytes() {
        return new BytesArray(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    public void seek(int position) {
        this.count = position;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    public void close() throws IOException {
    }
}

