/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.multibindings;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.binder.LinkedBindingBuilder;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.multibindings.Element;
import org.elasticsearch.common.inject.multibindings.RealElement;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.HasDependencies;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.util.Types;

public abstract class Multibinder<T> {
    private Multibinder() {
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type2) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder result2 = new RealMultibinder(binder, type2, "", Key.get(Multibinder.setOf(type2)));
        binder.install(result2);
        return result2;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type2) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type2));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type2, Annotation annotation2) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder result2 = new RealMultibinder(binder, type2, ((Object)annotation2).toString(), Key.get(Multibinder.setOf(type2), annotation2));
        binder.install(result2);
        return result2;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type2, Annotation annotation2) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type2), annotation2);
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type2, Class<? extends Annotation> annotationType) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder result2 = new RealMultibinder(binder, type2, "@" + annotationType.getName(), Key.get(Multibinder.setOf(type2), annotationType));
        binder.install(result2);
        return result2;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type2, Class<? extends Annotation> annotationType) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type2), annotationType);
    }

    private static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<T> elementType) {
        ParameterizedType type2 = Types.setOf(elementType.getType());
        return TypeLiteral.get(type2);
    }

    public abstract LinkedBindingBuilder<T> addBinding();

    static void checkConfiguration(boolean condition, String format, Object ... args2) {
        if (condition) {
            return;
        }
        throw new ConfigurationException(ImmutableSet.of(new Message(Errors.format(format, args2))));
    }

    static <T> T checkNotNull(T reference2, String name2) {
        if (reference2 != null) {
            return reference2;
        }
        NullPointerException npe = new NullPointerException(name2);
        throw new ConfigurationException(ImmutableSet.of(new Message(ImmutableList.<Object>of(), npe.toString(), npe)));
    }

    static final class RealMultibinder<T>
    extends Multibinder<T>
    implements Module,
    Provider<Set<T>>,
    HasDependencies {
        private final TypeLiteral<T> elementType;
        private final String setName;
        private final Key<Set<T>> setKey;
        private Binder binder;
        private List<Provider<T>> providers;
        private Set<Dependency<?>> dependencies;

        private RealMultibinder(Binder binder, TypeLiteral<T> elementType, String setName, Key<Set<T>> setKey) {
            this.binder = RealMultibinder.checkNotNull(binder, "binder");
            this.elementType = RealMultibinder.checkNotNull(elementType, "elementType");
            this.setName = RealMultibinder.checkNotNull(setName, "setName");
            this.setKey = RealMultibinder.checkNotNull(setKey, "setKey");
        }

        @Override
        public void configure(Binder binder) {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            binder.bind(this.setKey).toProvider(this);
        }

        @Override
        public LinkedBindingBuilder<T> addBinding() {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            return this.binder.bind(Key.get(this.elementType, (Annotation)new RealElement(this.setName)));
        }

        @Inject
        void initialize(Injector injector) {
            this.providers = Lists.newArrayList();
            ArrayList<Dependency<T>> dependencies = Lists.newArrayList();
            for (Binding<T> entry : injector.findBindingsByType(this.elementType)) {
                if (!this.keyMatches(entry.getKey())) continue;
                Binding<T> binding2 = entry;
                this.providers.add(binding2.getProvider());
                dependencies.add(Dependency.get(binding2.getKey()));
            }
            this.dependencies = ImmutableSet.copyOf(dependencies);
            this.binder = null;
        }

        private boolean keyMatches(Key<?> key2) {
            return key2.getTypeLiteral().equals(this.elementType) && key2.getAnnotation() instanceof Element && ((Element)key2.getAnnotation()).setName().equals(this.setName);
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        @Override
        public Set<T> get() {
            RealMultibinder.checkConfiguration(this.isInitialized(), "Multibinder is not initialized", new Object[0]);
            LinkedHashSet<T> result2 = new LinkedHashSet<T>();
            for (Provider<T> provider : this.providers) {
                T newValue = provider.get();
                RealMultibinder.checkConfiguration(newValue != null, "Set injection failed due to null element", new Object[0]);
                RealMultibinder.checkConfiguration(result2.add(newValue), "Set injection failed due to duplicated element \"%s\"", newValue);
            }
            return Collections.unmodifiableSet(result2);
        }

        String getSetName() {
            return this.setName;
        }

        Key<Set<T>> getSetKey() {
            return this.setKey;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            return o instanceof RealMultibinder && ((RealMultibinder)o).setKey.equals(this.setKey);
        }

        public int hashCode() {
            return this.setKey.hashCode();
        }

        public String toString() {
            return this.setName + (this.setName.length() > 0 ? " " : "") + "Multibinder<" + this.elementType + ">";
        }
    }
}

