/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Provides;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ProviderMethod;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.util.Modules;

public final class ProviderMethodsModule
implements Module {
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;

    private ProviderMethodsModule(Object delegate2) {
        this.delegate = Preconditions.checkNotNull(delegate2, "delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module);
    }

    public static Module forObject(Object object) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object);
    }

    @Override
    public synchronized void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        ArrayList<ProviderMethod<?>> result2 = Lists.newArrayList();
        for (Class<?> c = this.delegate.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method2 : c.getDeclaredMethods()) {
                if (!method2.isAnnotationPresent(Provides.class)) continue;
                result2.add(this.createProviderMethod(binder, method2));
            }
        }
        return result2;
    }

    <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method2) {
        Key<?> key2;
        binder = binder.withSource(method2);
        Errors errors = new Errors(method2);
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        ArrayList<Provider<?>> parameterProviders = Lists.newArrayList();
        List<TypeLiteral<?>> parameterTypes = this.typeLiteral.getParameterTypes(method2);
        Annotation[][] parameterAnnotations = method2.getParameterAnnotations();
        for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
            key2 = this.getKey(errors, parameterTypes.get(i2), method2, parameterAnnotations[i2]);
            dependencies.add(Dependency.get(key2));
            parameterProviders.add(binder.getProvider(key2));
        }
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method2);
        key2 = this.getKey(errors, returnType, method2, method2.getAnnotations());
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method2.getAnnotations());
        for (Message message2 : errors.getMessages()) {
            binder.addError(message2);
        }
        return new ProviderMethod(key2, method2, this.delegate, ImmutableSet.copyOf(dependencies), parameterProviders, scopeAnnotation);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type2, Member member, Annotation[] annotations2) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations2);
        return bindingAnnotation == null ? Key.get(type2) : Key.get(type2, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof ProviderMethodsModule && ((ProviderMethodsModule)o).delegate == this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

