/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Exposed;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.PrivateBinder;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.ProviderWithDependencies;

public class ProviderMethod<T>
implements ProviderWithDependencies<T> {
    private final Key<T> key;
    private final Class<? extends Annotation> scopeAnnotation;
    private final Object instance;
    private final Method method;
    private final ImmutableSet<Dependency<?>> dependencies;
    private final List<Provider<?>> parameterProviders;
    private final boolean exposed;

    ProviderMethod(Key<T> key2, Method method2, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation) {
        this.key = key2;
        this.scopeAnnotation = scopeAnnotation;
        this.instance = instance;
        this.dependencies = dependencies;
        this.method = method2;
        this.parameterProviders = parameterProviders;
        this.exposed = method2.isAnnotationPresent(Exposed.class);
        method2.setAccessible(true);
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void configure(Binder binder) {
        binder = binder.withSource(this.method);
        if (this.scopeAnnotation != null) {
            binder.bind(this.key).toProvider(this).in(this.scopeAnnotation);
        } else {
            binder.bind(this.key).toProvider(this);
        }
        if (this.exposed) {
            ((PrivateBinder)binder).expose(this.key);
        }
    }

    @Override
    public T get() {
        Object[] parameters2 = new Object[this.parameterProviders.size()];
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            parameters2[i2] = this.parameterProviders.get(i2).get();
        }
        try {
            Object result2 = this.method.invoke(this.instance, parameters2);
            return (T)result2;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }
}

