/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.State;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.WeakKeySet;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.MatcherAndConverter;
import org.elasticsearch.common.inject.spi.TypeListenerBinding;

class InheritingState
implements State {
    private final State parent;
    private final Map<Key<?>, Binding<?>> explicitBindingsMutable = Maps.newLinkedHashMap();
    private final Map<Key<?>, Binding<?>> explicitBindings = Collections.unmodifiableMap(this.explicitBindingsMutable);
    private final Map<Class<? extends Annotation>, Scope> scopes = Maps.newHashMap();
    private final List<MatcherAndConverter> converters = Lists.newArrayList();
    private final List<TypeListenerBinding> listenerBindings = Lists.newArrayList();
    private WeakKeySet blacklistedKeys = new WeakKeySet();
    private final Object lock;

    InheritingState(State parent) {
        this.parent = Preconditions.checkNotNull(parent, "parent");
        this.lock = parent == State.NONE ? this : parent.lock();
    }

    @Override
    public State parent() {
        return this.parent;
    }

    @Override
    public <T> BindingImpl<T> getExplicitBinding(Key<T> key2) {
        Binding<?> binding2 = this.explicitBindings.get(key2);
        return binding2 != null ? (BindingImpl<T>)binding2 : this.parent.getExplicitBinding(key2);
    }

    @Override
    public Map<Key<?>, Binding<?>> getExplicitBindingsThisLevel() {
        return this.explicitBindings;
    }

    @Override
    public void putBinding(Key<?> key2, BindingImpl<?> binding2) {
        this.explicitBindingsMutable.put(key2, binding2);
    }

    @Override
    public Scope getScope(Class<? extends Annotation> annotationType) {
        Scope scope = this.scopes.get(annotationType);
        return scope != null ? scope : this.parent.getScope(annotationType);
    }

    @Override
    public void putAnnotation(Class<? extends Annotation> annotationType, Scope scope) {
        this.scopes.put(annotationType, scope);
    }

    @Override
    public Iterable<MatcherAndConverter> getConvertersThisLevel() {
        return this.converters;
    }

    @Override
    public void addConverter(MatcherAndConverter matcherAndConverter) {
        this.converters.add(matcherAndConverter);
    }

    @Override
    public MatcherAndConverter getConverter(String stringValue, TypeLiteral<?> type2, Errors errors, Object source2) {
        MatcherAndConverter matchingConverter = null;
        for (State s2 = this; s2 != State.NONE; s2 = s2.parent()) {
            for (MatcherAndConverter converter : s2.getConvertersThisLevel()) {
                if (!converter.getTypeMatcher().matches(type2)) continue;
                if (matchingConverter != null) {
                    errors.ambiguousTypeConversion(stringValue, source2, type2, matchingConverter, converter);
                }
                matchingConverter = converter;
            }
        }
        return matchingConverter;
    }

    @Override
    public void addTypeListener(TypeListenerBinding listenerBinding) {
        this.listenerBindings.add(listenerBinding);
    }

    @Override
    public List<TypeListenerBinding> getTypeListenerBindings() {
        List<TypeListenerBinding> parentBindings = this.parent.getTypeListenerBindings();
        ArrayList<TypeListenerBinding> result2 = new ArrayList<TypeListenerBinding>(parentBindings.size() + 1);
        result2.addAll(parentBindings);
        result2.addAll(this.listenerBindings);
        return result2;
    }

    @Override
    public void blacklist(Key<?> key2) {
        this.parent.blacklist(key2);
        this.blacklistedKeys.add(key2);
    }

    @Override
    public boolean isBlacklisted(Key<?> key2) {
        return this.blacklistedKeys.contains(key2);
    }

    @Override
    public void clearBlacklisted() {
        this.blacklistedKeys = new WeakKeySet();
    }

    @Override
    public Object lock() {
        return this.lock;
    }
}

