/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.elasticsearch.common.compress.lzf.ChunkEncoder;
import org.elasticsearch.common.compress.lzf.LZFChunk;

public class LZFEncoder {
    private LZFEncoder() {
    }

    public static byte[] encode(byte[] data2) throws IOException {
        return LZFEncoder.encode(data2, data2.length);
    }

    public static byte[] encode(byte[] data2, int length2) throws IOException {
        return LZFEncoder.encode(data2, 0, length2);
    }

    public static byte[] encode(byte[] data2, int offset2, int length2) throws IOException {
        ChunkEncoder enc = new ChunkEncoder(length2);
        byte[] result2 = LZFEncoder.encode(enc, data2, offset2, length2);
        enc.close();
        return result2;
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data2, int length2) throws IOException {
        return LZFEncoder.encode(enc, data2, 0, length2);
    }

    public static byte[] encode(ChunkEncoder enc, byte[] data2, int offset2, int length2) throws IOException {
        int left2 = length2;
        int chunkLen = Math.min(65535, left2);
        LZFChunk first2 = enc.encodeChunk(data2, offset2, chunkLen);
        if ((left2 -= chunkLen) < 1) {
            return first2.getData();
        }
        int resultBytes = first2.length();
        offset2 += chunkLen;
        LZFChunk last2 = first2;
        do {
            chunkLen = Math.min(left2, 65535);
            LZFChunk chunk2 = enc.encodeChunk(data2, offset2, chunkLen);
            offset2 += chunkLen;
            resultBytes += chunk2.length();
            last2.setNext(chunk2);
            last2 = chunk2;
        } while ((left2 -= chunkLen) > 0);
        byte[] result2 = new byte[resultBytes];
        int ptr = 0;
        while (first2 != null) {
            ptr = first2.copyTo(result2, ptr);
            first2 = first2.next();
        }
        return result2;
    }
}

