/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.OutputStream;

public class LZFChunk {
    public static final int MAX_LITERAL = 32;
    public static final int MAX_CHUNK_LEN = 65535;
    public static final int MAX_HEADER_LEN = 7;
    public static final byte BYTE_Z = 90;
    public static final byte BYTE_V = 86;
    public static final int BLOCK_TYPE_NON_COMPRESSED = 0;
    public static final int BLOCK_TYPE_COMPRESSED = 1;
    protected final byte[] _data;
    protected LZFChunk _next;

    private LZFChunk(byte[] data2) {
        this._data = data2;
    }

    public static LZFChunk createCompressed(int origLen, byte[] encData, int encPtr, int encLen) {
        byte[] result2 = new byte[encLen + 7];
        result2[0] = 90;
        result2[1] = 86;
        result2[2] = 1;
        result2[3] = (byte)(encLen >> 8);
        result2[4] = (byte)encLen;
        result2[5] = (byte)(origLen >> 8);
        result2[6] = (byte)origLen;
        System.arraycopy(encData, encPtr, result2, 7, encLen);
        return new LZFChunk(result2);
    }

    public static int appendCompressedHeader(int origLen, int encLen, byte[] headerBuffer, int offset2) throws IOException {
        headerBuffer[offset2++] = 90;
        headerBuffer[offset2++] = 86;
        headerBuffer[offset2++] = 1;
        headerBuffer[offset2++] = (byte)(encLen >> 8);
        headerBuffer[offset2++] = (byte)encLen;
        headerBuffer[offset2++] = (byte)(origLen >> 8);
        headerBuffer[offset2++] = (byte)origLen;
        return offset2;
    }

    public static void writeCompressedHeader(int origLen, int encLen, OutputStream out, byte[] headerBuffer) throws IOException {
        headerBuffer[0] = 90;
        headerBuffer[1] = 86;
        headerBuffer[2] = 1;
        headerBuffer[3] = (byte)(encLen >> 8);
        headerBuffer[4] = (byte)encLen;
        headerBuffer[5] = (byte)(origLen >> 8);
        headerBuffer[6] = (byte)origLen;
        out.write(headerBuffer, 0, 7);
    }

    public static LZFChunk createNonCompressed(byte[] plainData, int ptr, int len) {
        byte[] result2 = new byte[len + 5];
        result2[0] = 90;
        result2[1] = 86;
        result2[2] = 0;
        result2[3] = (byte)(len >> 8);
        result2[4] = (byte)len;
        System.arraycopy(plainData, ptr, result2, 5, len);
        return new LZFChunk(result2);
    }

    public static int appendNonCompressedHeader(int len, byte[] headerBuffer, int offset2) throws IOException {
        headerBuffer[offset2++] = 90;
        headerBuffer[offset2++] = 86;
        headerBuffer[offset2++] = 0;
        headerBuffer[offset2++] = (byte)(len >> 8);
        headerBuffer[offset2++] = (byte)len;
        return offset2;
    }

    public static void writeNonCompressedHeader(int len, OutputStream out, byte[] headerBuffer) throws IOException {
        headerBuffer[0] = 90;
        headerBuffer[1] = 86;
        headerBuffer[2] = 0;
        headerBuffer[3] = (byte)(len >> 8);
        headerBuffer[4] = (byte)len;
        out.write(headerBuffer, 0, 5);
    }

    public void setNext(LZFChunk next) {
        this._next = next;
    }

    public LZFChunk next() {
        return this._next;
    }

    public int length() {
        return this._data.length;
    }

    public byte[] getData() {
        return this._data;
    }

    public int copyTo(byte[] dst, int ptr) {
        int len = this._data.length;
        System.arraycopy(this._data, 0, dst, ptr, len);
        return ptr + len;
    }
}

