/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.compress.lzf.LZFException;

public abstract class ChunkDecoder {
    protected static final byte BYTE_NULL = 0;
    protected static final int HEADER_BYTES = 5;

    public final byte[] decode(byte[] inputBuffer) throws IOException {
        byte[] result2 = new byte[ChunkDecoder.calculateUncompressedSize(inputBuffer, 0, inputBuffer.length)];
        this.decode(inputBuffer, 0, inputBuffer.length, result2);
        return result2;
    }

    public final byte[] decode(byte[] inputBuffer, int inputPtr, int inputLen) throws IOException {
        byte[] result2 = new byte[ChunkDecoder.calculateUncompressedSize(inputBuffer, inputPtr, inputLen)];
        this.decode(inputBuffer, inputPtr, inputLen, result2);
        return result2;
    }

    public final int decode(byte[] inputBuffer, byte[] targetBuffer) throws IOException {
        return this.decode(inputBuffer, 0, inputBuffer.length, targetBuffer);
    }

    public int decode(byte[] sourceBuffer, int inPtr, int inLength, byte[] targetBuffer) throws IOException {
        int outPtr = 0;
        int blockNr = 0;
        int end2 = inPtr + inLength - 1;
        while (inPtr < end2) {
            if (sourceBuffer[inPtr] != 90 || sourceBuffer[inPtr + 1] != 86) {
                throw new LZFException("Corrupt input data, block #" + blockNr + " (at offset " + inPtr + "): did not start with 'ZV' signature bytes");
            }
            inPtr += 2;
            byte type2 = sourceBuffer[inPtr++];
            int len = ChunkDecoder.uint16(sourceBuffer, inPtr);
            inPtr += 2;
            if (type2 == 0) {
                if (outPtr + len > targetBuffer.length) {
                    this._reportArrayOverflow(targetBuffer, outPtr, len);
                }
                System.arraycopy(sourceBuffer, inPtr, targetBuffer, outPtr, len);
                outPtr += len;
            } else {
                int uncompLen = ChunkDecoder.uint16(sourceBuffer, inPtr);
                if (outPtr + uncompLen > targetBuffer.length) {
                    this._reportArrayOverflow(targetBuffer, outPtr, uncompLen);
                }
                this.decodeChunk(sourceBuffer, inPtr += 2, targetBuffer, outPtr, outPtr + uncompLen);
                outPtr += uncompLen;
            }
            inPtr += len;
            ++blockNr;
        }
        return outPtr;
    }

    public abstract int decodeChunk(InputStream var1, byte[] var2, byte[] var3) throws IOException;

    public abstract void decodeChunk(byte[] var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    public abstract int skipOrDecodeChunk(InputStream var1, byte[] var2, byte[] var3, long var4) throws IOException;

    public static int calculateUncompressedSize(byte[] data2, int ptr, int length2) throws IOException {
        int uncompressedSize = 0;
        int blockNr = 0;
        int end2 = ptr + length2;
        while (ptr < end2) {
            if (ptr == data2.length + 1 && data2[ptr] == 0) {
                ++ptr;
                break;
            }
            try {
                if (data2[ptr] != 90 || data2[ptr + 1] != 86) {
                    throw new LZFException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): did not start with 'ZV' signature bytes");
                }
                byte type2 = data2[ptr + 2];
                int blockLen = ChunkDecoder.uint16(data2, ptr + 3);
                if (type2 == 0) {
                    ptr += 5;
                    uncompressedSize += blockLen;
                } else if (type2 == 1) {
                    uncompressedSize += ChunkDecoder.uint16(data2, ptr + 5);
                    ptr += 7;
                } else {
                    throw new LZFException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): unrecognized block type " + (type2 & 0xFF));
                }
                ptr += blockLen;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new LZFException("Corrupt input data, block #" + blockNr + " (at offset " + ptr + "): truncated block header");
            }
            ++blockNr;
        }
        if (ptr != end2) {
            throw new LZFException("Corrupt input data: block #" + blockNr + " extends " + (data2.length - ptr) + " beyond end of input");
        }
        return uncompressedSize;
    }

    protected static final int uint16(byte[] data2, int ptr) {
        return ((data2[ptr] & 0xFF) << 8) + (data2[ptr + 1] & 0xFF);
    }

    protected static final int readHeader(InputStream is, byte[] inputBuffer) throws IOException {
        int needed = 5;
        int count2 = is.read(inputBuffer, 0, needed);
        if (count2 == needed) {
            return count2;
        }
        if (count2 <= 0) {
            return 0;
        }
        int offset2 = count2;
        needed -= count2;
        while ((count2 = is.read(inputBuffer, offset2, needed)) > 0) {
            offset2 += count2;
            if ((needed -= count2) > 0) continue;
        }
        return offset2;
    }

    protected static final void readFully(InputStream is, boolean compressed, byte[] outputBuffer, int offset2, int len) throws IOException {
        int count2;
        for (int left2 = len; left2 > 0; left2 -= count2) {
            count2 = is.read(outputBuffer, offset2, left2);
            if (count2 < 0) {
                throw new LZFException("EOF in " + len + " byte (" + (compressed ? "" : "un") + "compressed) block: could only read " + (len - left2) + " bytes");
            }
            offset2 += count2;
        }
    }

    protected static final void skipFully(InputStream is, int amount) throws IOException {
        int orig = amount;
        while (amount > 0) {
            long skipped = is.skip(amount);
            if (skipped <= 0L) {
                throw new LZFException("Input problem: failed to skip " + orig + " bytes in input stream, only skipped " + (orig - amount));
            }
            amount -= (int)skipped;
        }
    }

    protected void _reportCorruptHeader() throws IOException {
        throw new LZFException("Corrupt input data, block did not start with 2 byte signature ('ZV') followed by type byte, 2-byte length)");
    }

    protected void _reportArrayOverflow(byte[] targetBuffer, int outPtr, int dataLen) throws IOException {
        throw new LZFException("Target buffer too small (" + targetBuffer.length + "): can not copy/uncompress " + dataLen + " bytes to offset " + outPtr);
    }
}

