/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.compress.CompressorContext;
import org.elasticsearch.common.util.BigLongArray;

public abstract class CompressedIndexInput<T extends CompressorContext>
extends IndexInput {
    private IndexInput in;
    protected final T context;
    private int version;
    private long totalUncompressedLength;
    private BigLongArray offsets;
    private boolean closed;
    protected byte[] uncompressed;
    protected int uncompressedLength;
    private int position = 0;
    private int valid = 0;
    private int currentOffsetIdx;
    private long currentUncompressedChunkPointer;

    public CompressedIndexInput(IndexInput in, T context) throws IOException {
        super("compressed(" + in.toString() + ")");
        this.in = in;
        this.context = context;
        this.readHeader(in);
        this.version = in.readInt();
        long metaDataPosition = in.readLong();
        long headerLength = in.getFilePointer();
        in.seek(metaDataPosition);
        this.totalUncompressedLength = in.readVLong();
        int size2 = in.readVInt();
        this.offsets = new BigLongArray(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.offsets.set(i2, in.readVLong());
        }
        this.currentOffsetIdx = -1;
        this.currentUncompressedChunkPointer = 0L;
        in.seek(headerLength);
    }

    public int available() throws IOException {
        if (this.closed) {
            return -1;
        }
        int left2 = this.valid - this.position;
        return left2 <= 0 ? 0 : left2;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.readyBuffer()) {
            throw new EOFException();
        }
        return this.uncompressed[this.position++];
    }

    public int read(byte[] buffer, int offset2, int length2, boolean fullRead) throws IOException {
        if (length2 < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this.valid - this.position, length2);
        System.arraycopy(this.uncompressed, this.position, buffer, offset2, chunkLength);
        this.position += chunkLength;
        if (chunkLength == length2 || !fullRead) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset2 += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this.valid - this.position, length2 - totalRead);
            System.arraycopy(this.uncompressed, this.position, buffer, offset2, chunkLength);
            this.position += chunkLength;
        } while ((totalRead += chunkLength) < length2);
        return totalRead;
    }

    @Override
    public void readBytes(byte[] b, int offset2, int len) throws IOException {
        int result2 = this.read(b, offset2, len, true);
        if (result2 < len) {
            throw new EOFException();
        }
    }

    @Override
    public long getFilePointer() {
        return this.currentUncompressedChunkPointer + (long)this.position;
    }

    @Override
    public void seek(long pos2) throws IOException {
        int idx = (int)(pos2 / (long)this.uncompressedLength);
        if (idx >= this.offsets.size) {
            this.currentOffsetIdx = idx;
            this.position = 0;
            this.valid = 0;
            return;
        }
        if (idx != this.currentOffsetIdx) {
            long pointer2 = this.offsets.get(idx);
            this.in.seek(pointer2);
            this.position = 0;
            this.valid = 0;
            this.currentOffsetIdx = idx - 1;
            this.readyBuffer();
        }
        this.position = (int)(pos2 % (long)this.uncompressedLength);
    }

    @Override
    public long length() {
        return this.totalUncompressedLength;
    }

    @Override
    public void close() throws IOException {
        this.valid = 0;
        this.position = 0;
        if (!this.closed) {
            this.closed = true;
            this.doClose();
            this.in.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected boolean readyBuffer() throws IOException {
        if (this.position < this.valid) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        if (this.currentOffsetIdx + 1 >= this.offsets.size) {
            return false;
        }
        this.valid = this.uncompress(this.in, this.uncompressed);
        if (this.valid < 0) {
            return false;
        }
        ++this.currentOffsetIdx;
        this.currentUncompressedChunkPointer = (long)this.currentOffsetIdx * (long)this.uncompressedLength;
        this.position = 0;
        return this.position < this.valid;
    }

    protected abstract void readHeader(IndexInput var1) throws IOException;

    protected abstract int uncompress(IndexInput var1, byte[] var2) throws IOException;

    @Override
    public Object clone() {
        CompressedIndexInput cloned = (CompressedIndexInput)super.clone();
        cloned.uncompressed = new byte[this.uncompressedLength];
        System.arraycopy(this.uncompressed, 0, cloned.uncompressed, 0, this.uncompressedLength);
        cloned.in = (IndexInput)cloned.in.clone();
        return cloned;
    }
}

