/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.collect.ImmutableAsList;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableMultiset;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Multiset;
import org.elasticsearch.common.collect.Multisets;
import org.elasticsearch.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size2) {
        this.map = map;
        this.size = size2;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@Nullable Object element) {
        Integer value2 = this.map.get(element);
        return value2 == null ? 0 : value2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    private static <E> Multiset.Entry<E> entryFromMapEntry(Map.Entry<E, Integer> entry) {
        return Multisets.immutableEntry(entry.getKey(), entry.getValue());
    }

    @Override
    ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private class EntrySet
    extends ImmutableMultiset.EntrySet {
        private EntrySet() {
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.map.size();
        }

        @Override
        public UnmodifiableIterator<Multiset.Entry<E>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ImmutableList<Multiset.Entry<E>> createAsList() {
            final ImmutableList entryList = ((ImmutableCollection)((Object)RegularImmutableMultiset.this.map.entrySet())).asList();
            return new ImmutableAsList<Multiset.Entry<E>>(){

                @Override
                public Multiset.Entry<E> get(int index2) {
                    return RegularImmutableMultiset.entryFromMapEntry((Map.Entry)entryList.get(index2));
                }

                @Override
                ImmutableCollection<Multiset.Entry<E>> delegateCollection() {
                    return EntrySet.this;
                }
            };
        }
    }
}

