/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.Hashing;
import org.elasticsearch.common.collect.ImmutableEntry;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableMapEntrySet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.RegularImmutableAsList;
import org.elasticsearch.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient LinkedEntry<K, V>[] entries;
    private final transient LinkedEntry<K, V>[] table;
    private final transient int mask;
    private static final double MAX_LOAD_FACTOR = 1.2;
    private static final long serialVersionUID = 0L;

    RegularImmutableMap(Map.Entry<?, ?> ... immutableEntries) {
        int size2 = immutableEntries.length;
        this.entries = this.createEntryArray(size2);
        int tableSize = Hashing.closedTableSize(size2, 1.2);
        this.table = this.createEntryArray(tableSize);
        this.mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < size2; ++entryIndex) {
            LinkedEntry<K, V> existing;
            Map.Entry<?, ?> entry = immutableEntries[entryIndex];
            Object key2 = entry.getKey();
            int keyHashCode = key2.hashCode();
            int tableIndex = Hashing.smear(keyHashCode) & this.mask;
            LinkedEntry<?, ?> linkedEntry = RegularImmutableMap.newLinkedEntry(key2, entry.getValue(), existing);
            this.table[tableIndex] = linkedEntry;
            this.entries[entryIndex] = linkedEntry;
            for (existing = this.table[tableIndex]; existing != null; existing = existing.next()) {
                Preconditions.checkArgument(!key2.equals(existing.getKey()), "duplicate key: %s", key2);
            }
        }
    }

    private LinkedEntry<K, V>[] createEntryArray(int size2) {
        return new LinkedEntry[size2];
    }

    private static <K, V> LinkedEntry<K, V> newLinkedEntry(K key2, V value2, @Nullable LinkedEntry<K, V> next) {
        return (LinkedEntry)((Object)(next == null ? new TerminalEntry<K, V>(key2, value2) : new NonTerminalEntry<K, V>(key2, value2, next)));
    }

    @Override
    public V get(@Nullable Object key2) {
        if (key2 == null) {
            return null;
        }
        int index2 = Hashing.smear(key2.hashCode()) & this.mask;
        for (LinkedEntry<K, V> entry = this.table[index2]; entry != null; entry = entry.next()) {
            Object candidateKey = entry.getKey();
            if (!key2.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet();
    }

    private class EntrySet
    extends ImmutableMapEntrySet<K, V> {
        private EntrySet() {
        }

        @Override
        ImmutableMap<K, V> map() {
            return RegularImmutableMap.this;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new RegularImmutableAsList(this, RegularImmutableMap.this.entries);
        }
    }

    @Immutable
    private static final class TerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        TerminalEntry(K key2, V value2) {
            super(key2, value2);
        }

        @Override
        @Nullable
        public LinkedEntry<K, V> next() {
            return null;
        }
    }

    @Immutable
    private static final class NonTerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        final LinkedEntry<K, V> next;

        NonTerminalEntry(K key2, V value2, LinkedEntry<K, V> next) {
            super(key2, value2);
            this.next = next;
        }

        @Override
        public LinkedEntry<K, V> next() {
            return this.next;
        }
    }

    private static interface LinkedEntry<K, V>
    extends Map.Entry<K, V> {
        @Nullable
        public LinkedEntry<K, V> next();
    }
}

