/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.ObjectArrays;
import org.elasticsearch.common.collect.UnmodifiableListIterator;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] array, int offset2, int size2) {
        this.offset = offset2;
        this.size = size2;
        this.array = array;
    }

    RegularImmutableList(Object[] array) {
        this(array, 0, array.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.offset != 0 || this.size != this.array.length;
    }

    @Override
    public Object[] toArray() {
        Object[] newArray = new Object[this.size()];
        System.arraycopy(this.array, this.offset, newArray, 0, this.size);
        return newArray;
    }

    @Override
    public <T> T[] toArray(T[] other) {
        if (other.length < this.size) {
            other = ObjectArrays.newArray(other, this.size);
        } else if (other.length > this.size) {
            other[this.size] = null;
        }
        System.arraycopy(this.array, this.offset, other, 0, this.size);
        return other;
    }

    @Override
    public E get(int index2) {
        Preconditions.checkElementIndex(index2, this.size);
        return (E)this.array[index2 + this.offset];
    }

    @Override
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        return new RegularImmutableList<E>(this.array, this.offset + fromIndex, toIndex - fromIndex);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index2) {
        return Iterators.forArray(this.array, this.offset, this.size, index2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List that = (List)object;
        if (this.size() != that.size()) {
            return false;
        }
        int index2 = this.offset;
        if (object instanceof RegularImmutableList) {
            RegularImmutableList other = (RegularImmutableList)object;
            for (int i2 = other.offset; i2 < other.offset + other.size; ++i2) {
                if (this.array[index2++].equals(other.array[i2])) continue;
                return false;
            }
        } else {
            for (Object element : that) {
                if (this.array[index2++].equals(element)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = Collections2.newStringBuilderForCollection(this.size()).append('[').append(this.array[this.offset]);
        for (int i2 = this.offset + 1; i2 < this.offset + this.size; ++i2) {
            sb.append(", ").append(this.array[i2]);
        }
        return sb.append(']').toString();
    }
}

