/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.Hashing;
import org.elasticsearch.common.collect.ImmutableAsList;
import org.elasticsearch.common.collect.ImmutableBiMap;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableEntry;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableMapEntrySet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.RegularImmutableAsList;
import org.elasticsearch.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final double MAX_LOAD_FACTOR = 1.2;
    private final transient BiMapEntry<K, V>[] kToVTable;
    private final transient BiMapEntry<K, V>[] vToKTable;
    private final transient BiMapEntry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    private transient ImmutableBiMap<V, K> inverse;

    RegularImmutableBiMap(Collection<? extends Map.Entry<? extends K, ? extends V>> entriesToAdd) {
        int n = entriesToAdd.size();
        int tableSize = Hashing.closedTableSize(n, 1.2);
        this.mask = tableSize - 1;
        BiMapEntry<K, V>[] kToVTable = RegularImmutableBiMap.createEntryArray(tableSize);
        BiMapEntry<K, V>[] vToKTable = RegularImmutableBiMap.createEntryArray(tableSize);
        BiMapEntry<K, V>[] entries2 = RegularImmutableBiMap.createEntryArray(n);
        int i2 = 0;
        int hashCode = 0;
        for (Map.Entry<K, V> entry : entriesToAdd) {
            BiMapEntry<K, V> nextInVToKBucket;
            BiMapEntry<K, V> nextInKToVBucket;
            K key2 = Preconditions.checkNotNull(entry.getKey());
            V value2 = Preconditions.checkNotNull(entry.getValue());
            int keyHash = key2.hashCode();
            int valueHash = value2.hashCode();
            int keyBucket = Hashing.smear(keyHash) & this.mask;
            int valueBucket = Hashing.smear(valueHash) & this.mask;
            for (BiMapEntry<K, V> kToVEntry = nextInKToVBucket = kToVTable[keyBucket]; kToVEntry != null; kToVEntry = kToVEntry.getNextInKToVBucket()) {
                if (!key2.equals(kToVEntry.getKey())) continue;
                throw new IllegalArgumentException("Multiple entries with same key: " + entry + " and " + kToVEntry);
            }
            for (BiMapEntry<K, V> vToKEntry = nextInVToKBucket = vToKTable[valueBucket]; vToKEntry != null; vToKEntry = vToKEntry.getNextInVToKBucket()) {
                if (!value2.equals(vToKEntry.getValue())) continue;
                throw new IllegalArgumentException("Multiple entries with same value: " + entry + " and " + vToKEntry);
            }
            BiMapEntry newEntry = nextInKToVBucket == null && nextInVToKBucket == null ? new BiMapEntry<K, V>(key2, value2) : new NonTerminalBiMapEntry<K, V>(key2, value2, nextInKToVBucket, nextInVToKBucket);
            kToVTable[keyBucket] = newEntry;
            vToKTable[valueBucket] = newEntry;
            entries2[i2++] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        this.kToVTable = kToVTable;
        this.vToKTable = vToKTable;
        this.entries = entries2;
        this.hashCode = hashCode;
    }

    private static <K, V> BiMapEntry<K, V>[] createEntryArray(int length2) {
        return new BiMapEntry[length2];
    }

    @Override
    @Nullable
    public V get(@Nullable Object key2) {
        if (key2 == null) {
            return null;
        }
        int bucket = Hashing.smear(key2.hashCode()) & this.mask;
        for (BiMapEntry<K, V> entry = this.kToVTable[bucket]; entry != null; entry = entry.getNextInKToVBucket()) {
            if (!key2.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet<K, V>(){

            @Override
            ImmutableMap<K, V> map() {
                return RegularImmutableBiMap.this;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                return this.asList().iterator();
            }

            @Override
            ImmutableList<Map.Entry<K, V>> createAsList() {
                return new RegularImmutableAsList(this, RegularImmutableBiMap.this.entries);
            }

            @Override
            boolean isHashCodeFast() {
                return true;
            }

            @Override
            public int hashCode() {
                return RegularImmutableBiMap.this.hashCode;
            }
        };
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        Inverse result2 = this.inverse;
        return result2 == null ? (this.inverse = new Inverse()) : result2;
    }

    private static class InverseSerializedForm<K, V>
    implements Serializable {
        private final ImmutableBiMap<K, V> forward;
        private static final long serialVersionUID = 1L;

        InverseSerializedForm(ImmutableBiMap<K, V> forward) {
            this.forward = forward;
        }

        Object readResolve() {
            return this.forward.inverse();
        }
    }

    private final class Inverse
    extends ImmutableBiMap<V, K> {
        private Inverse() {
        }

        @Override
        public int size() {
            return this.inverse().size();
        }

        @Override
        public ImmutableBiMap<K, V> inverse() {
            return RegularImmutableBiMap.this;
        }

        @Override
        public K get(@Nullable Object value2) {
            if (value2 == null) {
                return null;
            }
            int bucket = Hashing.smear(value2.hashCode()) & RegularImmutableBiMap.this.mask;
            for (BiMapEntry entry = RegularImmutableBiMap.this.vToKTable[bucket]; entry != null; entry = entry.getNextInVToKBucket()) {
                if (!value2.equals(entry.getValue())) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        ImmutableSet<Map.Entry<V, K>> createEntrySet() {
            return new InverseEntrySet();
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        Object writeReplace() {
            return new InverseSerializedForm(RegularImmutableBiMap.this);
        }

        final class InverseEntrySet
        extends ImmutableMapEntrySet<V, K> {
            InverseEntrySet() {
            }

            @Override
            ImmutableMap<V, K> map() {
                return Inverse.this;
            }

            @Override
            boolean isHashCodeFast() {
                return true;
            }

            @Override
            public int hashCode() {
                return RegularImmutableBiMap.this.hashCode;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<V, K>> iterator() {
                return this.asList().iterator();
            }

            @Override
            ImmutableList<Map.Entry<V, K>> createAsList() {
                return new ImmutableAsList<Map.Entry<V, K>>(){

                    @Override
                    public Map.Entry<V, K> get(int index2) {
                        BiMapEntry entry = RegularImmutableBiMap.this.entries[index2];
                        return Maps.immutableEntry(entry.getValue(), entry.getKey());
                    }

                    @Override
                    ImmutableCollection<Map.Entry<V, K>> delegateCollection() {
                        return InverseEntrySet.this;
                    }
                };
            }
        }
    }

    private static class NonTerminalBiMapEntry<K, V>
    extends BiMapEntry<K, V> {
        @Nullable
        private final BiMapEntry<K, V> nextInKToVBucket;
        @Nullable
        private final BiMapEntry<K, V> nextInVToKBucket;

        NonTerminalBiMapEntry(K key2, V value2, @Nullable BiMapEntry<K, V> nextInKToVBucket, @Nullable BiMapEntry<K, V> nextInVToKBucket) {
            super(key2, value2);
            this.nextInKToVBucket = nextInKToVBucket;
            this.nextInVToKBucket = nextInVToKBucket;
        }

        @Override
        @Nullable
        BiMapEntry<K, V> getNextInKToVBucket() {
            return this.nextInKToVBucket;
        }

        @Override
        @Nullable
        BiMapEntry<K, V> getNextInVToKBucket() {
            return this.nextInVToKBucket;
        }
    }

    private static class BiMapEntry<K, V>
    extends ImmutableEntry<K, V> {
        BiMapEntry(K key2, V value2) {
            super(key2, value2);
        }

        @Nullable
        BiMapEntry<K, V> getNextInKToVBucket() {
            return null;
        }

        @Nullable
        BiMapEntry<K, V> getNextInVToKBucket() {
            return null;
        }
    }
}

