/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.collect.ImmutableAsList;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.UnmodifiableListIterator;

@GwtCompatible
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate2, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate2;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate2, Object[] array) {
        this(delegate2, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index2) {
        return this.delegateList.listIterator(index2);
    }

    @Override
    public Object[] toArray() {
        return this.delegateList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] other) {
        return this.delegateList.toArray(other);
    }

    @Override
    public int indexOf(Object object) {
        return this.delegateList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.delegateList.lastIndexOf(object);
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegateList.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegateList.hashCode();
    }

    @Override
    public E get(int index2) {
        return this.delegateList.get(index2);
    }
}

