/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.lang.reflect.Array;
import java.util.Collection;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.annotations.GwtIncompatible;
import org.elasticsearch.common.collect.Platform;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type2, int length2) {
        return (Object[])Array.newInstance(type2, length2);
    }

    public static <T> T[] newArray(T[] reference2, int length2) {
        return Platform.newArray(reference2, length2);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first2, T[] second, Class<T> type2) {
        T[] result2 = ObjectArrays.newArray(type2, first2.length + second.length);
        System.arraycopy(first2, 0, result2, 0, first2.length);
        System.arraycopy(second, 0, result2, first2.length, second.length);
        return result2;
    }

    public static <T> T[] concat(@Nullable T element, T[] array) {
        T[] result2 = ObjectArrays.newArray(array, array.length + 1);
        result2[0] = element;
        System.arraycopy(array, 0, result2, 1, array.length);
        return result2;
    }

    public static <T> T[] concat(T[] array, @Nullable T element) {
        T[] result2 = ObjectArrays.arraysCopyOf(array, array.length + 1);
        result2[array.length] = element;
        return result2;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        T[] copy = ObjectArrays.newArray(original, newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array) {
        int size2 = c.size();
        if (array.length < size2) {
            array = ObjectArrays.newArray(array, size2);
        }
        ObjectArrays.fillArray(c, array);
        if (array.length > size2) {
            array[size2] = null;
        }
        return array;
    }

    static Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int i2 = 0;
        for (Object element : elements) {
            array[i2++] = element;
        }
        return array;
    }

    static void swap(Object[] array, int i2, int j) {
        Object temp = array[i2];
        array[i2] = array[j];
        array[j] = temp;
    }

    static Object checkElementNotNull(Object element, int index2) {
        if (element == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element;
    }
}

