/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cache;

import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.Beta;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.cache.RemovalCause;

@Beta
@GwtCompatible
public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    @Nullable
    private final K key;
    @Nullable
    private final V value;
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    RemovalNotification(@Nullable K key2, @Nullable V value2, RemovalCause cause2) {
        this.key = key2;
        this.value = value2;
        this.cause = Preconditions.checkNotNull(cause2);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public final V setValue(V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

