/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public class BytesArray
implements BytesReference {
    public static final BytesArray EMPTY = new BytesArray(Bytes.EMPTY_ARRAY, 0, 0);
    private byte[] bytes;
    private int offset;
    private int length;

    public BytesArray(String bytes2) {
        this(bytes2.getBytes(Charsets.UTF_8));
    }

    public BytesArray(byte[] bytes2) {
        this.bytes = bytes2;
        this.offset = 0;
        this.length = bytes2.length;
    }

    public BytesArray(byte[] bytes2, int offset2, int length2) {
        this.bytes = bytes2;
        this.offset = offset2;
        this.length = length2;
    }

    @Override
    public byte get(int index2) {
        return this.bytes[this.offset + index2];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length2) {
        if (from < 0 || from + length2 > this.length) {
            throw new ElasticSearchIllegalArgumentException("can't slice a buffer with length [" + this.length + "], with slice parameters from [" + from + "], length [" + length2 + "]");
        }
        return new BytesArray(this.bytes, this.offset + from, length2);
    }

    @Override
    public StreamInput streamInput() {
        return new BytesStreamInput(this.bytes, this.offset, this.length, false);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.bytes, this.offset, this.length);
    }

    @Override
    public byte[] toBytes() {
        if (this.offset == 0 && this.bytes.length == this.length) {
            return this.bytes;
        }
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    @Override
    public BytesArray toBytesArray() {
        return this;
    }

    @Override
    public BytesArray copyBytesArray() {
        return new BytesArray(Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length));
    }

    @Override
    public ChannelBuffer toChannelBuffer() {
        return ChannelBuffers.wrappedBuffer(this.bytes, this.offset, this.length);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.bytes;
    }

    @Override
    public int arrayOffset() {
        return this.offset;
    }

    @Override
    public String toUtf8() {
        if (this.length == 0) {
            return "";
        }
        return new String(this.bytes, this.offset, this.length, Charsets.UTF_8);
    }

    public boolean equals(Object obj) {
        return this.bytesEquals((BytesArray)obj);
    }

    public boolean bytesEquals(BytesArray other) {
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end2 = this.offset + this.length;
            int upto2 = this.offset;
            while (upto2 < end2) {
                if (this.bytes[upto2] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto2;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result2 = 0;
        int end2 = this.offset + this.length;
        for (int i2 = this.offset; i2 < end2; ++i2) {
            result2 = 31 * result2 + this.bytes[i2];
        }
        return result2;
    }
}

