/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.fs.AbstractFsBlobContainer;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.BlobStores;
import org.elasticsearch.common.io.FileSystemUtils;

public class FsImmutableBlobContainer
extends AbstractFsBlobContainer
implements ImmutableBlobContainer {
    public FsImmutableBlobContainer(FsBlobStore blobStore, BlobPath blobPath, File path2) {
        super(blobStore, blobPath, path2);
    }

    @Override
    public void writeBlob(final String blobName, final InputStream is, final long sizeInBytes, final ImmutableBlobContainer.WriterListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RandomAccessFile raf;
                File file2 = new File(FsImmutableBlobContainer.this.path, blobName);
                try {
                    raf = new RandomAccessFile(file2, "rw");
                    raf.setLength(0L);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return;
                }
                try {
                    try {
                        int bytesRead;
                        long bytesWritten = 0L;
                        byte[] buffer = new byte[FsImmutableBlobContainer.this.blobStore.bufferSizeInBytes()];
                        while ((bytesRead = is.read(buffer)) != -1) {
                            raf.write(buffer, 0, bytesRead);
                            bytesWritten += (long)bytesRead;
                        }
                        if (bytesWritten != sizeInBytes) {
                            listener.onFailure(new ElasticSearchIllegalStateException("[" + blobName + "]: wrote [" + bytesWritten + "], expected to write [" + sizeInBytes + "]"));
                            return;
                        }
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {}
                        try {
                            raf.close();
                        }
                        catch (IOException ex) {}
                    }
                    FileSystemUtils.syncFile(file2);
                    listener.onCompleted();
                }
                catch (Exception e) {
                    try {
                        if (file2.exists()) {
                            file2.delete();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    listener.onFailure(e);
                }
            }
        });
    }

    @Override
    public void writeBlob(String blobName, InputStream is, long sizeInBytes) throws IOException {
        BlobStores.syncWriteBlob(this, blobName, is, sizeInBytes);
    }
}

