/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.File;
import java.util.concurrent.Executor;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.fs.FsImmutableBlobContainer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class FsBlobStore
extends AbstractComponent
implements BlobStore {
    private final Executor executor;
    private final File path;
    private final int bufferSizeInBytes;

    public FsBlobStore(Settings settings, Executor executor, File path2) {
        super(settings);
        boolean b;
        this.path = path2;
        if (!path2.exists() && !(b = FileSystemUtils.mkdirs(path2))) {
            throw new BlobStoreException("Failed to create directory at [" + path2 + "]");
        }
        if (!path2.isDirectory()) {
            throw new BlobStoreException("Path is not a directory at [" + path2 + "]");
        }
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).bytes();
        this.executor = executor;
    }

    public String toString() {
        return this.path.toString();
    }

    public File path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public Executor executor() {
        return this.executor;
    }

    @Override
    public ImmutableBlobContainer immutableBlobContainer(BlobPath path2) {
        return new FsImmutableBlobContainer(this, path2, this.buildAndCreate(path2));
    }

    @Override
    public void delete(BlobPath path2) {
        FileSystemUtils.deleteRecursively(this.buildPath(path2));
    }

    @Override
    public void close() {
    }

    private synchronized File buildAndCreate(BlobPath path2) {
        File f = this.buildPath(path2);
        FileSystemUtils.mkdirs(f);
        return f;
    }

    private File buildPath(BlobPath path2) {
        String[] paths = path2.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        File blobPath = new File(this.path, paths[0]);
        if (paths.length > 1) {
            for (int i2 = 1; i2 < paths.length; ++i2) {
                blobPath = new File(blobPath, paths[i2]);
            }
        }
        return blobPath;
    }
}

