/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Collection;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.ElasticSearchNullPointerException;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new ElasticSearchIllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ElasticSearchIllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new ElasticSearchIllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new ElasticSearchIllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ElasticSearchIllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new ElasticSearchIllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference2) {
        if (reference2 == null) {
            throw new ElasticSearchNullPointerException();
        }
        return reference2;
    }

    public static <T> T checkNotNull(T reference2, Object errorMessage) {
        if (reference2 == null) {
            throw new ElasticSearchNullPointerException(String.valueOf(errorMessage));
        }
        return reference2;
    }

    public static <T> T checkNotNull(T reference2, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference2 == null) {
            throw new ElasticSearchNullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference2;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable) {
        if (Preconditions.containsOrIsNull(iterable)) {
            throw new ElasticSearchNullPointerException();
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable, Object errorMessage) {
        if (Preconditions.containsOrIsNull(iterable)) {
            throw new ElasticSearchNullPointerException(String.valueOf(errorMessage));
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Preconditions.containsOrIsNull(iterable)) {
            throw new ElasticSearchNullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return iterable;
    }

    private static boolean containsOrIsNull(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            try {
                return collection.contains(null);
            }
            catch (ElasticSearchNullPointerException e) {
                return false;
            }
        }
        for (Object element : iterable) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    public static void checkElementIndex(int index2, int size2) {
        Preconditions.checkElementIndex(index2, size2, "index");
    }

    public static void checkElementIndex(int index2, int size2, String desc) {
        Preconditions.checkArgument(size2 >= 0, "negative size: %s", size2);
        if (index2 < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", desc, index2));
        }
        if (index2 >= size2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must be less than size (%s)", desc, index2, size2));
        }
    }

    public static void checkPositionIndex(int index2, int size2) {
        Preconditions.checkPositionIndex(index2, size2, "index");
    }

    public static void checkPositionIndex(int index2, int size2, String desc) {
        Preconditions.checkArgument(size2 >= 0, "negative size: %s", size2);
        if (index2 < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", desc, index2));
        }
        if (index2 > size2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index2, size2));
        }
    }

    public static void checkPositionIndexes(int start2, int end2, int size2) {
        Preconditions.checkPositionIndex(start2, size2, "start index");
        Preconditions.checkPositionIndex(end2, size2, "end index");
        if (end2 < start2) {
            throw new IndexOutOfBoundsException(Preconditions.format("end index (%s) must not be less than start index (%s)", end2, start2));
        }
    }

    static String format(String template, Object ... args2) {
        int placeholderStart;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i2 = 0;
        while (i2 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args2[i2++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i2 < args2.length) {
            builder.append(" [");
            builder.append(args2[i2++]);
            while (i2 < args2.length) {
                builder.append(", ");
                builder.append(args2[i2++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

