/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

public class MurmurHash {
    public static int hash32(byte[] data2, int offset2, int length2, int seed2) {
        int m = 1540483477;
        int r = 24;
        int h = seed2 ^ length2;
        int len_4 = length2 >> 2;
        for (int i2 = 0; i2 < len_4; ++i2) {
            int i_4 = i2 << 2;
            int k = data2[offset2 + i_4 + 3];
            k <<= 8;
            k |= data2[offset2 + i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data2[offset2 + i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data2[offset2 + i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left2 = length2 - len_m;
        if (left2 != 0) {
            if (left2 >= 3) {
                h ^= data2[offset2 + length2 - 3] << 16;
            }
            if (left2 >= 2) {
                h ^= data2[offset2 + length2 - 2] << 8;
            }
            if (left2 >= 1) {
                h ^= data2[offset2 + length2 - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static long hash2_64(byte[] key2, int offset2, int length2, long seed2) {
        long m64 = -4132994306676758123L;
        int r64 = 47;
        long h64 = seed2 & 0xFFFFFFFFL ^ m64 * (long)length2;
        int lenLongs = length2 >> 3;
        for (int i2 = 0; i2 < lenLongs; ++i2) {
            int i_8 = i2 << 3;
            long k64 = ((long)key2[offset2 + i_8 + 0] & 0xFFL) + (((long)key2[offset2 + i_8 + 1] & 0xFFL) << 8) + (((long)key2[offset2 + i_8 + 2] & 0xFFL) << 16) + (((long)key2[offset2 + i_8 + 3] & 0xFFL) << 24) + (((long)key2[offset2 + i_8 + 4] & 0xFFL) << 32) + (((long)key2[offset2 + i_8 + 5] & 0xFFL) << 40) + (((long)key2[offset2 + i_8 + 6] & 0xFFL) << 48) + (((long)key2[offset2 + i_8 + 7] & 0xFFL) << 56);
            k64 *= m64;
            k64 ^= k64 >>> r64;
            h64 ^= (k64 *= m64);
            h64 *= m64;
        }
        int rem = length2 & 7;
        switch (rem) {
            case 0: {
                break;
            }
            case 7: {
                h64 ^= (long)key2[offset2 + length2 - rem + 6] << 48;
            }
            case 6: {
                h64 ^= (long)key2[offset2 + length2 - rem + 5] << 40;
            }
            case 5: {
                h64 ^= (long)key2[offset2 + length2 - rem + 4] << 32;
            }
            case 4: {
                h64 ^= (long)key2[offset2 + length2 - rem + 3] << 24;
            }
            case 3: {
                h64 ^= (long)key2[offset2 + length2 - rem + 2] << 16;
            }
            case 2: {
                h64 ^= (long)key2[offset2 + length2 - rem + 1] << 8;
            }
            case 1: {
                h64 ^= (long)key2[offset2 + length2 - rem];
                h64 *= m64;
            }
        }
        h64 ^= h64 >>> r64;
        h64 *= m64;
        h64 ^= h64 >>> r64;
        return h64;
    }

    protected static long getblock(byte[] key2, int offset2, int index2) {
        int i_8 = index2 << 3;
        int blockOffset = offset2 + i_8;
        return ((long)key2[blockOffset + 0] & 0xFFL) + (((long)key2[blockOffset + 1] & 0xFFL) << 8) + (((long)key2[blockOffset + 2] & 0xFFL) << 16) + (((long)key2[blockOffset + 3] & 0xFFL) << 24) + (((long)key2[blockOffset + 4] & 0xFFL) << 32) + (((long)key2[blockOffset + 5] & 0xFFL) << 40) + (((long)key2[blockOffset + 6] & 0xFFL) << 48) + (((long)key2[blockOffset + 7] & 0xFFL) << 56);
    }

    protected static long rotl64(long v, int n) {
        return v << n | v >>> 64 - n;
    }

    protected static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long[] hash3_x64_128(byte[] key2, int offset2, int length2, long seed2) {
        int nblocks = length2 >> 4;
        long h1 = seed2;
        long h2 = seed2;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            long k1 = MurmurHash.getblock(key2, offset2, i2 * 2 + 0);
            long k2 = MurmurHash.getblock(key2, offset2, i2 * 2 + 1);
            k1 *= c1;
            k1 = MurmurHash.rotl64(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = MurmurHash.rotl64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = MurmurHash.rotl64(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = MurmurHash.rotl64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset2 += nblocks * 16;
        long k1 = 0L;
        long k2 = 0L;
        switch (length2 & 0xF) {
            case 15: {
                k2 ^= (long)key2[offset2 + 14] << 48;
            }
            case 14: {
                k2 ^= (long)key2[offset2 + 13] << 40;
            }
            case 13: {
                k2 ^= (long)key2[offset2 + 12] << 32;
            }
            case 12: {
                k2 ^= (long)key2[offset2 + 11] << 24;
            }
            case 11: {
                k2 ^= (long)key2[offset2 + 10] << 16;
            }
            case 10: {
                k2 ^= (long)key2[offset2 + 9] << 8;
            }
            case 9: {
                k2 ^= (long)key2[offset2 + 8] << 0;
                k2 *= c2;
                k2 = MurmurHash.rotl64(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)key2[offset2 + 7] << 56;
            }
            case 7: {
                k1 ^= (long)key2[offset2 + 6] << 48;
            }
            case 6: {
                k1 ^= (long)key2[offset2 + 5] << 40;
            }
            case 5: {
                k1 ^= (long)key2[offset2 + 4] << 32;
            }
            case 4: {
                k1 ^= (long)key2[offset2 + 3] << 24;
            }
            case 3: {
                k1 ^= (long)key2[offset2 + 2] << 16;
            }
            case 2: {
                k1 ^= (long)key2[offset2 + 1] << 8;
            }
            case 1: {
                k1 ^= (long)key2[offset2];
                k1 *= c1;
                k1 = MurmurHash.rotl64(k1, 31);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (long)length2;
        h1 += (h2 ^= (long)length2);
        h2 += h1;
        h1 = MurmurHash.fmix(h1);
        h2 = MurmurHash.fmix(h2);
        h1 += h2;
        return new long[]{h1, h2 += h1};
    }
}

