/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.elasticsearch.ElasticSearchIllegalStateException;

public class Hex {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static char[] encodeHex(byte[] data2) {
        return Hex.encodeHex(data2, true);
    }

    public static char[] encodeHex(byte[] data2, boolean toLowerCase) {
        return Hex.encodeHex(data2, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data2, char[] toDigits) {
        int l = data2.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i2 = 0; i2 < l; ++i2) {
            out[j++] = toDigits[(0xF0 & data2[i2]) >>> 4];
            out[j++] = toDigits[0xF & data2[i2]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data2) {
        return new String(Hex.encodeHex(data2));
    }

    public static byte[] decodeHex(String data2) throws ElasticSearchIllegalStateException {
        return Hex.decodeHex(data2.toCharArray());
    }

    public static byte[] decodeHex(char[] data2) throws ElasticSearchIllegalStateException {
        int len = data2.length;
        if ((len & 1) != 0) {
            throw new ElasticSearchIllegalStateException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i2 = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data2[j], j) << 4;
            f |= Hex.toDigit(data2[++j], j);
            ++j;
            out[i2] = (byte)(f & 0xFF);
            ++i2;
        }
        return out;
    }

    protected static int toDigit(char ch, int index2) throws ElasticSearchIllegalStateException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new ElasticSearchIllegalStateException("Illegal hexadecimal character " + ch + " at index " + index2);
        }
        return digit;
    }
}

