/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.Lists;

public class RoutingNode
implements Iterable<MutableShardRouting> {
    private final String nodeId;
    private final DiscoveryNode node;
    private final List<MutableShardRouting> shards;

    public RoutingNode(String nodeId, DiscoveryNode node) {
        this(nodeId, node, new ArrayList<MutableShardRouting>());
    }

    public RoutingNode(String nodeId, DiscoveryNode node, List<MutableShardRouting> shards) {
        this.nodeId = nodeId;
        this.node = node;
        this.shards = shards;
    }

    @Override
    public Iterator<MutableShardRouting> iterator() {
        return this.shards.iterator();
    }

    public DiscoveryNode node() {
        return this.node;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public List<MutableShardRouting> shards() {
        return this.shards;
    }

    public void add(MutableShardRouting shard) {
        for (MutableShardRouting shardRouting : this.shards) {
            if (!shardRouting.shardId().equals(shard.shardId())) continue;
            throw new ElasticSearchIllegalStateException("Trying to add a shard [" + shard.shardId().index().name() + "][" + shard.shardId().id() + "] to a node [" + this.nodeId + "] where it already exists");
        }
        this.shards.add(shard);
        shard.assignToNode(this.node.id());
    }

    public void removeByShardId(int shardId) {
        Iterator<MutableShardRouting> it = this.shards.iterator();
        while (it.hasNext()) {
            MutableShardRouting shard = it.next();
            if (shard.id() != shardId) continue;
            it.remove();
        }
    }

    public int numberOfShardsWithState(ShardRoutingState ... states) {
        int count2 = 0;
        for (MutableShardRouting shardEntry : this) {
            for (ShardRoutingState state2 : states) {
                if (shardEntry.state() != state2) continue;
                ++count2;
            }
        }
        return count2;
    }

    public List<MutableShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (MutableShardRouting shardEntry : this) {
            for (ShardRoutingState state2 : states) {
                if (shardEntry.state() != state2) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<MutableShardRouting> shardsWithState(String index2, ShardRoutingState ... states) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (MutableShardRouting shardEntry : this) {
            if (!shardEntry.index().equals(index2)) continue;
            for (ShardRoutingState state2 : states) {
                if (shardEntry.state() != state2) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public int numberOfShardsNotWithState(ShardRoutingState state2) {
        int count2 = 0;
        for (MutableShardRouting shardEntry : this) {
            if (shardEntry.state() == state2) continue;
            ++count2;
        }
        return count2;
    }

    public int numberOfOwningShards() {
        int count2 = 0;
        for (MutableShardRouting shardEntry : this) {
            if (shardEntry.state() == ShardRoutingState.RELOCATING) continue;
            ++count2;
        }
        return count2;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----node_id[").append(this.nodeId).append("][" + (this.node == null ? "X" : "V") + "]\n");
        for (MutableShardRouting entry : this.shards) {
            sb.append("--------").append(entry.shortSummary()).append('\n');
        }
        return sb.toString();
    }
}

