/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.List;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;

public class PlainShardsIterator
implements ShardsIterator {
    private final List<ShardRouting> shards;
    private final int size;
    private final int index;
    private final int limit;
    private volatile int counter;

    public PlainShardsIterator(List<ShardRouting> shards) {
        this(shards, 0);
    }

    public PlainShardsIterator(List<ShardRouting> shards, int index2) {
        this.shards = shards;
        this.size = shards.size();
        this.index = this.size == 0 ? 0 : Math.abs(index2 % this.size);
        this.counter = this.index;
        this.limit = this.index + this.size;
    }

    @Override
    public ShardsIterator reset() {
        this.counter = this.index;
        return this;
    }

    @Override
    public int remaining() {
        return this.limit - this.counter;
    }

    @Override
    public ShardRouting firstOrNull() {
        if (this.size == 0) {
            return null;
        }
        return this.shards.get(this.index);
    }

    @Override
    public ShardRouting nextOrNull() {
        if (this.size == 0) {
            return null;
        }
        int counter = this.counter;
        if (counter >= this.size) {
            if (counter >= this.limit) {
                return null;
            }
            this.counter = counter + 1;
            return this.shards.get(counter - this.size);
        }
        this.counter = counter + 1;
        return this.shards.get(counter);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int sizeActive() {
        int count2 = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.shards.get(i2).active()) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public int assignedReplicasIncludingRelocating() {
        int count2 = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            ShardRouting shard = this.shards.get(i2);
            if (shard.unassigned()) continue;
            if (shard.primary()) {
                if (!shard.relocating()) continue;
                ++count2;
                continue;
            }
            ++count2;
            if (!shard.relocating()) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public Iterable<ShardRouting> asUnordered() {
        return this.shards;
    }
}

