/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;

public class MutableShardRouting
extends ImmutableShardRouting {
    public MutableShardRouting(ShardRouting copy) {
        super(copy);
    }

    public MutableShardRouting(ShardRouting copy, long version) {
        super(copy);
        this.version = version;
    }

    public MutableShardRouting(String index2, int shardId, String currentNodeId, boolean primary, ShardRoutingState state2, long version) {
        super(index2, shardId, currentNodeId, primary, state2, version);
    }

    public MutableShardRouting(String index2, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state2, long version) {
        super(index2, shardId, currentNodeId, relocatingNodeId, primary, state2, version);
    }

    public void assignToNode(String nodeId) {
        ++this.version;
        if (this.currentNodeId == null) {
            assert (this.state == ShardRoutingState.UNASSIGNED);
            this.state = ShardRoutingState.INITIALIZING;
            this.currentNodeId = nodeId;
            this.relocatingNodeId = null;
        } else if (this.state == ShardRoutingState.STARTED) {
            this.state = ShardRoutingState.RELOCATING;
            this.relocatingNodeId = nodeId;
        } else if (this.state == ShardRoutingState.RELOCATING) assert (nodeId.equals(this.relocatingNodeId));
    }

    public void relocate(String relocatingNodeId) {
        ++this.version;
        assert (this.state == ShardRoutingState.STARTED);
        this.state = ShardRoutingState.RELOCATING;
        this.relocatingNodeId = relocatingNodeId;
    }

    public void cancelRelocation() {
        ++this.version;
        assert (this.state == ShardRoutingState.RELOCATING);
        assert (this.assignedToNode());
        assert (this.relocatingNodeId != null);
        this.state = ShardRoutingState.STARTED;
        this.relocatingNodeId = null;
    }

    public void deassignNode() {
        ++this.version;
        assert (this.state != ShardRoutingState.UNASSIGNED);
        this.state = ShardRoutingState.UNASSIGNED;
        this.currentNodeId = null;
        this.relocatingNodeId = null;
    }

    public void moveToStarted() {
        ++this.version;
        assert (this.state == ShardRoutingState.INITIALIZING || this.state == ShardRoutingState.RELOCATING);
        this.relocatingNodeId = null;
        this.state = ShardRoutingState.STARTED;
    }

    public void moveToPrimary() {
        ++this.version;
        if (this.primary) {
            throw new IllegalShardRoutingStateException(this, "Already primary, can't move to primary");
        }
        this.primary = true;
    }

    public void moveFromPrimary() {
        ++this.version;
        if (!this.primary) {
            throw new IllegalShardRoutingStateException(this, "Already primary, can't move to replica");
        }
        this.primary = false;
    }
}

