/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardRoutingTable
implements Iterable<ShardRouting> {
    final ShardId shardId;
    final ShardRouting primary;
    final ImmutableList<ShardRouting> primaryAsList;
    final ImmutableList<ShardRouting> replicas;
    final ImmutableList<ShardRouting> shards;
    final ImmutableList<ShardRouting> activeShards;
    final ImmutableList<ShardRouting> assignedShards;
    final AtomicInteger counter;
    final boolean primaryAllocatedPostApi;
    private volatile Map<AttributesKey, AttributesRoutings> activeShardsByAttributes = ImmutableMap.of();
    private final Object shardsByAttributeMutex = new Object();

    IndexShardRoutingTable(ShardId shardId, ImmutableList<ShardRouting> shards, boolean primaryAllocatedPostApi) {
        this.shardId = shardId;
        this.shards = shards;
        this.primaryAllocatedPostApi = primaryAllocatedPostApi;
        this.counter = new AtomicInteger(ThreadLocalRandom.current().nextInt(shards.size()));
        ShardRouting primary = null;
        ArrayList<ShardRouting> replicas = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> activeShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> assignedShards = new ArrayList<ShardRouting>();
        for (ShardRouting shard : shards) {
            if (shard.primary()) {
                primary = shard;
            } else {
                replicas.add(shard);
            }
            if (shard.active()) {
                activeShards.add(shard);
            }
            if (!shard.assignedToNode()) continue;
            assignedShards.add(shard);
        }
        this.primary = primary;
        this.primaryAsList = primary != null ? ImmutableList.of(primary) : ImmutableList.of();
        this.replicas = ImmutableList.copyOf(replicas);
        this.activeShards = ImmutableList.copyOf(activeShards);
        this.assignedShards = ImmutableList.copyOf(assignedShards);
    }

    public IndexShardRoutingTable normalizeVersions() {
        if (this.shards.isEmpty()) {
            return this;
        }
        if (this.shards.size() == 1) {
            return this;
        }
        long highestVersion = ((ShardRouting)this.shards.get(0)).version();
        boolean requiresNormalization = false;
        for (int i2 = 1; i2 < this.shards.size(); ++i2) {
            if (((ShardRouting)this.shards.get(i2)).version() != highestVersion) {
                requiresNormalization = true;
            }
            if (((ShardRouting)this.shards.get(i2)).version() <= highestVersion) continue;
            highestVersion = ((ShardRouting)this.shards.get(i2)).version();
        }
        if (!requiresNormalization) {
            return this;
        }
        ArrayList shardRoutings = new ArrayList(this.shards.size());
        for (int i3 = 0; i3 < this.shards.size(); ++i3) {
            if (((ShardRouting)this.shards.get(i3)).version() == highestVersion) {
                shardRoutings.add(this.shards.get(i3));
                continue;
            }
            shardRoutings.add(new ImmutableShardRouting((ShardRouting)this.shards.get(i3), highestVersion));
        }
        return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(shardRoutings), this.primaryAllocatedPostApi);
    }

    public boolean primaryAllocatedPostApi() {
        return this.primaryAllocatedPostApi;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    @Override
    public UnmodifiableIterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }

    public int size() {
        return this.shards.size();
    }

    public int getSize() {
        return this.size();
    }

    public ImmutableList<ShardRouting> shards() {
        return this.shards;
    }

    public ImmutableList<ShardRouting> getShards() {
        return this.shards();
    }

    public ImmutableList<ShardRouting> activeShards() {
        return this.activeShards;
    }

    public ImmutableList<ShardRouting> getActiveShards() {
        return this.activeShards();
    }

    public ImmutableList<ShardRouting> assignedShards() {
        return this.assignedShards;
    }

    public ImmutableList<ShardRouting> getAssignedShards() {
        return this.assignedShards;
    }

    public int countWithState(ShardRoutingState state2) {
        int count2 = 0;
        for (ShardRouting shard : this) {
            if (state2 != shard.state()) continue;
            ++count2;
        }
        return count2;
    }

    public ShardIterator shardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.shards, this.counter.getAndIncrement());
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.shards);
    }

    public ShardIterator shardsIt(int index2) {
        return new PlainShardIterator(this.shardId, this.shards, index2);
    }

    public ShardIterator activeShardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.activeShards, this.counter.getAndIncrement());
    }

    public ShardIterator activeShardsIt() {
        return new PlainShardIterator(this.shardId, this.activeShards);
    }

    public ShardIterator activeShardsIt(int index2) {
        return new PlainShardIterator(this.shardId, this.activeShards, index2);
    }

    public ShardIterator assignedShardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.assignedShards, this.counter.getAndIncrement());
    }

    public ShardIterator assignedShardsIt() {
        return new PlainShardIterator(this.shardId, this.assignedShards);
    }

    public ShardIterator assignedShardsIt(int index2) {
        return new PlainShardIterator(this.shardId, this.assignedShards, index2);
    }

    public ShardIterator primaryShardIt() {
        return new PlainShardIterator(this.shardId, this.primaryAsList);
    }

    public ShardIterator primaryFirstActiveShardsIt() {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size());
        int index2 = Math.abs(this.counter.getAndIncrement());
        for (int i2 = 0; i2 < this.activeShards.size(); ++i2) {
            int loc = (index2 + i2) % this.activeShards.size();
            ShardRouting shardRouting = (ShardRouting)this.activeShards.get(loc);
            ordered.add(shardRouting);
            if (!shardRouting.primary()) continue;
            ordered.set(i2, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferNodeShardsIt(String nodeId) {
        return this.preferNodeShardsIt(nodeId, this.shards);
    }

    public ShardIterator onlyNodeActiveShardsIt(String nodeId) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.shards.size());
        for (int i2 = 0; i2 < this.shards.size(); ++i2) {
            ShardRouting shardRouting = (ShardRouting)this.shards.get(i2);
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferNodeActiveShardsIt(String nodeId) {
        return this.preferNodeShardsIt(nodeId, this.activeShards);
    }

    public ShardIterator preferNodeAssignedShardsIt(String nodeId) {
        return this.preferNodeShardsIt(nodeId, this.assignedShards);
    }

    private ShardIterator preferNodeShardsIt(String nodeId, ImmutableList<ShardRouting> shards) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(shards.size());
        int index2 = Math.abs(this.counter.getAndIncrement());
        for (int i2 = 0; i2 < shards.size(); ++i2) {
            int loc = (index2 + i2) % shards.size();
            ShardRouting shardRouting = (ShardRouting)shards.get(loc);
            ordered.add(shardRouting);
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.set(i2, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferAttributesActiveShardsIt(String[] attributes, DiscoveryNodes nodes) {
        return this.preferAttributesActiveShardsIt(attributes, nodes, this.counter.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShardIterator preferAttributesActiveShardsIt(String[] attributes, DiscoveryNodes nodes, int index2) {
        ShardRouting shardRouting;
        int i2;
        AttributesKey key2 = new AttributesKey(attributes);
        AttributesRoutings shardRoutings = this.activeShardsByAttributes.get(key2);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from = new ArrayList<ShardRouting>(this.activeShards);
                ArrayList<ShardRouting> to = new ArrayList<ShardRouting>();
                for (String attribute : attributes) {
                    String localAttributeValue = nodes.localNode().attributes().get(attribute);
                    if (localAttributeValue == null) continue;
                    Iterator<ShardRouting> iterator = from.iterator();
                    while (iterator.hasNext()) {
                        ShardRouting fromShard = iterator.next();
                        if (!localAttributeValue.equals(nodes.get(fromShard.currentNodeId()).attributes().get(attribute))) continue;
                        iterator.remove();
                        to.add(fromShard);
                    }
                }
                shardRoutings = new AttributesRoutings(ImmutableList.copyOf(to), ImmutableList.copyOf(from));
                this.activeShardsByAttributes = MapBuilder.newMapBuilder(this.activeShardsByAttributes).put(key2, shardRoutings).immutableMap();
            }
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(shardRoutings.totalSize);
        index2 = Math.abs(index2);
        for (i2 = 0; i2 < shardRoutings.withSameAttribute.size(); ++i2) {
            int loc = (index2 + i2) % shardRoutings.withSameAttribute.size();
            shardRouting = (ShardRouting)shardRoutings.withSameAttribute.get(loc);
            ordered.add(shardRouting);
        }
        for (i2 = 0; i2 < shardRoutings.withoutSameAttribute.size(); ++i2) {
            int loc = (index2 + i2) % shardRoutings.withoutSameAttribute.size();
            shardRouting = (ShardRouting)shardRoutings.withoutSameAttribute.get(loc);
            ordered.add(shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardRouting primaryShard() {
        return this.primary;
    }

    public List<ShardRouting> replicaShards() {
        return this.replicas;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state2 : states) {
                if (shardEntry.state() != state2) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public static class Builder {
        private ShardId shardId;
        private final List<ShardRouting> shards;
        private boolean primaryAllocatedPostApi;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = Lists.newArrayList(indexShard.shards);
            this.primaryAllocatedPostApi = indexShard.primaryAllocatedPostApi();
        }

        public Builder(ShardId shardId, boolean primaryAllocatedPostApi) {
            this.shardId = shardId;
            this.shards = Lists.newArrayList();
            this.primaryAllocatedPostApi = primaryAllocatedPostApi;
        }

        public Builder addShard(ImmutableShardRouting shardEntry) {
            for (ShardRouting shard : this.shards) {
                if (!shard.assignedToNode() || !shardEntry.assignedToNode() || !shard.currentNodeId().equals(shardEntry.currentNodeId())) continue;
                return this;
            }
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            if (!this.primaryAllocatedPostApi) {
                for (ShardRouting shardRouting : this.shards) {
                    if (!shardRouting.primary() || !shardRouting.active()) continue;
                    this.primaryAllocatedPostApi = true;
                }
            }
            return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(this.shards), this.primaryAllocatedPostApi);
        }

        public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
            String index2 = in.readUTF();
            return Builder.readFromThin(in, index2);
        }

        public static IndexShardRoutingTable readFromThin(StreamInput in, String index2) throws IOException {
            int iShardId = in.readVInt();
            boolean allocatedPostApi = in.readBoolean();
            Builder builder = new Builder(new ShardId(index2, iShardId), allocatedPostApi);
            int size2 = in.readVInt();
            for (int i2 = 0; i2 < size2; ++i2) {
                ImmutableShardRouting shard = ImmutableShardRouting.readShardRoutingEntry(in, index2, iShardId);
                builder.addShard(shard);
            }
            return builder.build();
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeUTF(indexShard.shardId().index().name());
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeBoolean(indexShard.primaryAllocatedPostApi());
            out.writeVInt(indexShard.shards.size());
            for (ShardRouting entry : indexShard) {
                entry.writeToThin(out);
            }
        }
    }

    static class AttributesRoutings {
        public final ImmutableList<ShardRouting> withSameAttribute;
        public final ImmutableList<ShardRouting> withoutSameAttribute;
        public final int totalSize;

        AttributesRoutings(ImmutableList<ShardRouting> withSameAttribute, ImmutableList<ShardRouting> withoutSameAttribute) {
            this.withSameAttribute = withSameAttribute;
            this.withoutSameAttribute = withoutSameAttribute;
            this.totalSize = withoutSameAttribute.size() + withSameAttribute.size();
        }
    }

    static class AttributesKey {
        final String[] attributes;

        AttributesKey(String[] attributes) {
            this.attributes = attributes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.attributes);
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.attributes, ((AttributesKey)obj).attributes);
        }
    }
}

