/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexTemplateMetaData {
    private final String name;
    private final int order;
    private final String template;
    private final Settings settings;
    private final ImmutableMap<String, CompressedString> mappings;
    private final ImmutableMap<String, IndexMetaData.Custom> customs;

    public IndexTemplateMetaData(String name2, int order2, String template, Settings settings, ImmutableMap<String, CompressedString> mappings, ImmutableMap<String, IndexMetaData.Custom> customs) {
        this.name = name2;
        this.order = order2;
        this.template = template;
        this.settings = settings;
        this.mappings = mappings;
        this.customs = customs;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    public String getName() {
        return this.name;
    }

    public String template() {
        return this.template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public ImmutableMap<String, CompressedString> mappings() {
        return this.mappings;
    }

    public ImmutableMap<String, CompressedString> getMappings() {
        return this.mappings;
    }

    public ImmutableMap<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public ImmutableMap<String, IndexMetaData.Custom> getCustoms() {
        return this.customs;
    }

    public <T extends IndexMetaData.Custom> T custom(String type2) {
        return (T)this.customs.get(type2);
    }

    public static Builder builder(String name2) {
        return new Builder(name2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetaData that = (IndexTemplateMetaData)o;
        if (this.order != that.order) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.template.equals(that.template);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.order;
        result2 = 31 * result2 + this.template.hashCode();
        result2 = 31 * result2 + this.settings.hashCode();
        result2 = 31 * result2 + this.mappings.hashCode();
        return result2;
    }

    public static class Builder {
        private String name;
        private int order;
        private String template;
        private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private MapBuilder<String, CompressedString> mappings = MapBuilder.newMapBuilder();
        private MapBuilder<String, IndexMetaData.Custom> customs = MapBuilder.newMapBuilder();

        public Builder(String name2) {
            this.name = name2;
        }

        public Builder(IndexTemplateMetaData indexTemplateMetaData) {
            this(indexTemplateMetaData.name());
            this.order(indexTemplateMetaData.order());
            this.template(indexTemplateMetaData.template());
            this.settings(indexTemplateMetaData.settings());
            this.mappings.putAll(indexTemplateMetaData.mappings());
            this.customs.putAll(indexTemplateMetaData.customs());
        }

        public Builder order(int order2) {
            this.order = order2;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public String template() {
            return this.template;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        public Builder putMapping(String mappingType, CompressedString mappingSource) throws IOException {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedString(mappingSource));
            return this;
        }

        public Builder putCustom(String type2, IndexMetaData.Custom customIndexMetaData) {
            this.customs.put(type2, customIndexMetaData);
            return this;
        }

        public Builder removeCustom(String type2) {
            this.customs.remove(type2);
            return this;
        }

        public IndexMetaData.Custom getCustom(String type2) {
            return this.customs.get(type2);
        }

        public IndexTemplateMetaData build() {
            return new IndexTemplateMetaData(this.name, this.order, this.template, this.settings, this.mappings.immutableMap(), this.customs.immutableMap());
        }

        public static void toXContent(IndexTemplateMetaData indexTemplateMetaData, XContentBuilder builder, ToXContent.Params params2) throws IOException {
            builder.startObject(indexTemplateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("order", indexTemplateMetaData.order());
            builder.field("template", indexTemplateMetaData.template());
            builder.startObject("settings");
            for (Map.Entry entry : indexTemplateMetaData.settings().getAsMap().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
            builder.startArray("mappings");
            for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                byte[] data2 = ((CompressedString)entry.getValue()).uncompressed();
                XContentParser parser = XContentFactory.xContent(data2).createParser(data2);
                Map<String, Object> mapping = parser.mapOrderedAndClose();
                builder.map(mapping);
            }
            builder.endArray();
            for (Map.Entry entry : indexTemplateMetaData.customs().entrySet()) {
                builder.startObject((String)entry.getKey(), XContentBuilder.FieldCaseConversion.NONE);
                IndexMetaData.lookupFactorySafe((String)entry.getKey()).toXContent((IndexMetaData.Custom)entry.getValue(), builder, params2);
                builder.endObject();
            }
            builder.endObject();
        }

        public static IndexTemplateMetaData fromXContentStandalone(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                throw new IOException("no data");
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IOException("should start object");
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new IOException("the first field should be the template name");
            }
            return Builder.fromXContent(parser);
        }

        public static IndexTemplateMetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.settings(ImmutableSettings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())));
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                            builder.putMapping(mappingType, XContentFactory.jsonBuilder().map(mappingSource).string());
                        }
                        continue;
                    }
                    IndexMetaData.Custom.Factory factory = IndexMetaData.lookupFactory(currentFieldName);
                    if (factory == null) {
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(factory.type(), (IndexMetaData.Custom)factory.fromXContent(parser));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Map<String, Object> mapping = parser.mapOrdered();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        String mappingSource = XContentFactory.jsonBuilder().map(mapping).string();
                        if (mappingSource == null) continue;
                        builder.putMapping(mappingType, mappingSource);
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("template".equals(currentFieldName)) {
                    builder.template(parser.text());
                    continue;
                }
                if (!"order".equals(currentFieldName)) continue;
                builder.order(parser.intValue());
            }
            return builder.build();
        }

        public static IndexTemplateMetaData readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder(in.readUTF());
            builder.order(in.readInt());
            builder.template(in.readUTF());
            builder.settings(ImmutableSettings.readSettingsFromStream(in));
            int mappingsSize = in.readVInt();
            for (int i2 = 0; i2 < mappingsSize; ++i2) {
                builder.putMapping(in.readUTF(), CompressedString.readCompressedString(in));
            }
            int customSize = in.readVInt();
            for (int i3 = 0; i3 < customSize; ++i3) {
                String type2 = in.readUTF();
                Object customIndexMetaData = IndexMetaData.lookupFactorySafe(type2).readFrom(in);
                builder.putCustom(type2, (IndexMetaData.Custom)customIndexMetaData);
            }
            return builder.build();
        }

        public static void writeTo(IndexTemplateMetaData indexTemplateMetaData, StreamOutput out) throws IOException {
            out.writeUTF(indexTemplateMetaData.name());
            out.writeInt(indexTemplateMetaData.order());
            out.writeUTF(indexTemplateMetaData.template());
            ImmutableSettings.writeSettingsToStream(indexTemplateMetaData.settings(), out);
            out.writeVInt(indexTemplateMetaData.mappings().size());
            for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                out.writeUTF((String)entry.getKey());
                ((CompressedString)entry.getValue()).writeTo(out);
            }
            out.writeVInt(indexTemplateMetaData.customs().size());
            for (Map.Entry entry : indexTemplateMetaData.customs().entrySet()) {
                out.writeUTF((String)entry.getKey());
                IndexMetaData.lookupFactorySafe((String)entry.getKey()).writeTo((IndexMetaData.Custom)entry.getValue(), out);
            }
        }
    }
}

