/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaDataStateIndexService;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlocks {
    public static final ClusterBlocks EMPTY_CLUSTER_BLOCK = new ClusterBlocks(ImmutableSet.<ClusterBlock>of(), ImmutableMap.<String, ImmutableSet<ClusterBlock>>of());
    private final ImmutableSet<ClusterBlock> global;
    private final ImmutableMap<String, ImmutableSet<ClusterBlock>> indicesBlocks;
    private final ImmutableLevelHolder[] levelHolders;

    ClusterBlocks(ImmutableSet<ClusterBlock> global, ImmutableMap<String, ImmutableSet<ClusterBlock>> indicesBlocks) {
        this.global = global;
        this.indicesBlocks = indicesBlocks;
        this.levelHolders = new ImmutableLevelHolder[ClusterBlockLevel.values().length];
        for (ClusterBlockLevel level2 : ClusterBlockLevel.values()) {
            ImmutableSet.Builder globalBuilder = ImmutableSet.builder();
            for (ClusterBlock block : global) {
                if (!block.contains(level2)) continue;
                globalBuilder.add(block);
            }
            ImmutableMap.Builder indicesBuilder = ImmutableMap.builder();
            for (Map.Entry entry : indicesBlocks.entrySet()) {
                ImmutableSet.Builder indexBuilder = ImmutableSet.builder();
                for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                    if (!block.contains(level2)) continue;
                    indexBuilder.add(block);
                }
                indicesBuilder.put(entry.getKey(), indexBuilder.build());
            }
            this.levelHolders[level2.id()] = new ImmutableLevelHolder((ImmutableSet<ClusterBlock>)globalBuilder.build(), indicesBuilder.build());
        }
    }

    public ImmutableSet<ClusterBlock> global() {
        return this.global;
    }

    public ImmutableMap<String, ImmutableSet<ClusterBlock>> indices() {
        return this.indicesBlocks;
    }

    public ImmutableSet<ClusterBlock> global(ClusterBlockLevel level2) {
        return this.levelHolders[level2.id()].global();
    }

    public ImmutableMap<String, ImmutableSet<ClusterBlock>> indices(ClusterBlockLevel level2) {
        return this.levelHolders[level2.id()].indices();
    }

    public boolean disableStatePersistence() {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.disableStatePersistence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlock block) {
        return this.global.contains(block);
    }

    public boolean hasGlobalBlock(RestStatus status2) {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexBlock(String index2, ClusterBlock block) {
        return this.indicesBlocks.containsKey(index2) && this.indicesBlocks.get(index2).contains(block);
    }

    public void globalBlockedRaiseException(ClusterBlockLevel level2) throws ClusterBlockException {
        ClusterBlockException blockException = this.globalBlockedException(level2);
        if (blockException != null) {
            throw blockException;
        }
    }

    public ClusterBlockException globalBlockedException(ClusterBlockLevel level2) {
        if (this.global(level2).isEmpty()) {
            return null;
        }
        return new ClusterBlockException(ImmutableSet.copyOf(this.global(level2)));
    }

    public void indexBlockedRaiseException(ClusterBlockLevel level2, String index2) throws ClusterBlockException {
        ClusterBlockException blockException = this.indexBlockedException(level2, index2);
        if (blockException != null) {
            throw blockException;
        }
    }

    public ClusterBlockException indexBlockedException(ClusterBlockLevel level2, String index2) {
        if (!this.indexBlocked(level2, index2)) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.global(level2));
        ImmutableSet<ClusterBlock> indexBlocks = this.indices(level2).get(index2);
        if (indexBlocks != null) {
            builder.addAll(indexBlocks);
        }
        return new ClusterBlockException((ImmutableSet<ClusterBlock>)builder.build());
    }

    public boolean indexBlocked(ClusterBlockLevel level2, String index2) {
        if (!this.global(level2).isEmpty()) {
            return true;
        }
        ImmutableSet<ClusterBlock> indexBlocks = this.indices(level2).get(index2);
        return indexBlocks != null && !indexBlocks.isEmpty();
    }

    public ClusterBlockException indicesBlockedException(ClusterBlockLevel level2, String[] indices2) {
        boolean indexIsBlocked = false;
        for (String index2 : indices2) {
            if (!this.indexBlocked(level2, index2)) continue;
            indexIsBlocked = true;
        }
        if (!indexIsBlocked) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.global(level2));
        for (String index3 : indices2) {
            ImmutableSet<ClusterBlock> indexBlocks = this.indices(level2).get(index3);
            if (indexBlocks == null) continue;
            builder.addAll(indexBlocks);
        }
        return new ClusterBlockException((ImmutableSet<ClusterBlock>)builder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<ClusterBlock> global = Sets.newHashSet();
        private Map<String, Set<ClusterBlock>> indices = Maps.newHashMap();

        public Builder blocks(ClusterBlocks blocks2) {
            this.global.addAll(blocks2.global());
            for (Map.Entry entry : blocks2.indices().entrySet()) {
                if (!this.indices.containsKey(entry.getKey())) {
                    this.indices.put((String)entry.getKey(), Sets.newHashSet());
                }
                this.indices.get(entry.getKey()).addAll((Collection)entry.getValue());
            }
            return this;
        }

        public Builder addBlocks(IndexMetaData indexMetaData) {
            if (indexMetaData.state() == IndexMetaData.State.CLOSE) {
                this.addIndexBlock(indexMetaData.index(), MetaDataStateIndexService.INDEX_CLOSED_BLOCK);
            }
            if (indexMetaData.settings().getAsBoolean("index.blocks.read_only", false).booleanValue()) {
                this.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_READ_ONLY_BLOCK);
            }
            if (indexMetaData.settings().getAsBoolean("index.blocks.read", false).booleanValue()) {
                this.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_READ_BLOCK);
            }
            if (indexMetaData.settings().getAsBoolean("index.blocks.write", false).booleanValue()) {
                this.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_WRITE_BLOCK);
            }
            if (indexMetaData.settings().getAsBoolean("index.blocks.metadata", false).booleanValue()) {
                this.addIndexBlock(indexMetaData.index(), IndexMetaData.INDEX_METADATA_BLOCK);
            }
            return this;
        }

        public Builder addGlobalBlock(ClusterBlock block) {
            this.global.add(block);
            return this;
        }

        public Builder removeGlobalBlock(ClusterBlock block) {
            this.global.remove(block);
            return this;
        }

        public Builder addIndexBlock(String index2, ClusterBlock block) {
            if (!this.indices.containsKey(index2)) {
                this.indices.put(index2, Sets.newHashSet());
            }
            this.indices.get(index2).add(block);
            return this;
        }

        public Builder removeIndexBlocks(String index2) {
            if (!this.indices.containsKey(index2)) {
                return this;
            }
            this.indices.remove(index2);
            return this;
        }

        public Builder removeIndexBlock(String index2, ClusterBlock block) {
            if (!this.indices.containsKey(index2)) {
                return this;
            }
            this.indices.get(index2).remove(block);
            if (this.indices.get(index2).isEmpty()) {
                this.indices.remove(index2);
            }
            return this;
        }

        public ClusterBlocks build() {
            ImmutableMap.Builder indicesBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Set<ClusterBlock>> entry : this.indices.entrySet()) {
                indicesBuilder.put(entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
            }
            return new ClusterBlocks(ImmutableSet.copyOf(this.global), indicesBuilder.build());
        }

        public static ClusterBlocks readClusterBlocks(StreamInput in) throws IOException {
            ImmutableSet<ClusterBlock> global = Builder.readBlockSet(in);
            ImmutableMap.Builder<String, ImmutableSet<ClusterBlock>> indicesBuilder = ImmutableMap.builder();
            int size2 = in.readVInt();
            for (int j = 0; j < size2; ++j) {
                indicesBuilder.put(in.readUTF().intern(), Builder.readBlockSet(in));
            }
            return new ClusterBlocks(global, indicesBuilder.build());
        }

        public static void writeClusterBlocks(ClusterBlocks blocks2, StreamOutput out) throws IOException {
            Builder.writeBlockSet(blocks2.global(), out);
            out.writeVInt(blocks2.indices().size());
            for (Map.Entry entry : blocks2.indices().entrySet()) {
                out.writeUTF((String)entry.getKey());
                Builder.writeBlockSet((ImmutableSet)entry.getValue(), out);
            }
        }

        private static void writeBlockSet(ImmutableSet<ClusterBlock> blocks2, StreamOutput out) throws IOException {
            out.writeVInt(blocks2.size());
            for (ClusterBlock block : blocks2) {
                block.writeTo(out);
            }
        }

        private static ImmutableSet<ClusterBlock> readBlockSet(StreamInput in) throws IOException {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int size2 = in.readVInt();
            for (int i2 = 0; i2 < size2; ++i2) {
                builder.add(ClusterBlock.readClusterBlock(in));
            }
            return builder.build();
        }
    }

    static class ImmutableLevelHolder {
        static final ImmutableLevelHolder EMPTY = new ImmutableLevelHolder(ImmutableSet.<ClusterBlock>of(), ImmutableMap.<String, ImmutableSet<ClusterBlock>>of());
        private final ImmutableSet<ClusterBlock> global;
        private final ImmutableMap<String, ImmutableSet<ClusterBlock>> indices;

        ImmutableLevelHolder(ImmutableSet<ClusterBlock> global, ImmutableMap<String, ImmutableSet<ClusterBlock>> indices2) {
            this.global = global;
            this.indices = indices2;
        }

        public ImmutableSet<ClusterBlock> global() {
            return this.global;
        }

        public ImmutableMap<String, ImmutableSet<ClusterBlock>> indices() {
            return this.indices;
        }
    }
}

