/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeIndexCreatedAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    @Inject
    public NodeIndexCreatedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("cluster/nodeIndexCreated", new NodeIndexCreatedTransportHandler());
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public void nodeIndexCreated(final String index2, final String nodeId) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    NodeIndexCreatedAction.this.innerNodeIndexCreated(index2, nodeId);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeIndexCreated", new NodeIndexCreatedMessage(index2, nodeId), EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerNodeIndexCreated(String index2, String nodeId) {
        for (Listener listener : this.listeners) {
            listener.onNodeIndexCreated(index2, nodeId);
        }
    }

    static class NodeIndexCreatedMessage
    extends TransportRequest {
        String index;
        String nodeId;

        NodeIndexCreatedMessage() {
        }

        NodeIndexCreatedMessage(String index2, String nodeId) {
            this.index = index2;
            this.nodeId = nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.nodeId = in.readString();
        }
    }

    private class NodeIndexCreatedTransportHandler
    extends BaseTransportRequestHandler<NodeIndexCreatedMessage> {
        static final String ACTION = "cluster/nodeIndexCreated";

        private NodeIndexCreatedTransportHandler() {
        }

        @Override
        public NodeIndexCreatedMessage newInstance() {
            return new NodeIndexCreatedMessage();
        }

        @Override
        public void messageReceived(NodeIndexCreatedMessage message2, TransportChannel channel) throws Exception {
            NodeIndexCreatedAction.this.innerNodeIndexCreated(message2.index, message2.nodeId);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onNodeIndexCreated(String var1, String var2);
    }
}

